/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ChainIdOperation
extends AbstractFixedCostOperation {
    public static final int OPCODE = 70;
    private final Bytes32 chainId;

    public ChainIdOperation(GasCalculator gasCalculator, Bytes32 chainId) {
        super(70, "CHAINID", 0, 1, gasCalculator, gasCalculator.getBaseTierGasCost());
        this.chainId = chainId;
    }

    public Bytes getChainId() {
        return this.chainId;
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        frame.pushStackItem((Bytes)this.chainId);
        return this.successResponse;
    }
}

