/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class IsZeroOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult isZeroSuccess = new Operation.OperationResult(3L, null);

    public IsZeroOperation(GasCalculator gasCalculator) {
        super(21, "ISZERO", 1, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return IsZeroOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value = frame.popStackItem().trimLeadingZeros();
        frame.pushStackItem(value.size() == 0 ? BYTES_ONE : Bytes.EMPTY);
        return isZeroSuccess;
    }
}

