/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.worldstate;

import java.util.NavigableMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.AccountState;
import org.hyperledger.besu.evm.account.AccountStorageEntry;
import org.hyperledger.besu.evm.worldstate.WorldView;

public interface WorldState
extends WorldView,
AutoCloseable {
    public Hash rootHash();

    public Hash frontierRootHash();

    public Stream<StreamableAccount> streamAccounts(Bytes32 var1, int var2);

    @Override
    default public void close() throws Exception {
    }

    public static class StreamableAccount
    implements AccountState {
        private final Optional<Address> address;
        private final AccountState accountState;

        public StreamableAccount(Optional<Address> address, AccountState accountState) {
            this.address = address;
            this.accountState = accountState;
        }

        public Optional<Address> getAddress() {
            return this.address;
        }

        @Override
        public Hash getAddressHash() {
            return this.accountState.getAddressHash();
        }

        @Override
        public long getNonce() {
            return this.accountState.getNonce();
        }

        @Override
        public Wei getBalance() {
            return this.accountState.getBalance();
        }

        @Override
        public Bytes getCode() {
            return this.accountState.getCode();
        }

        @Override
        public Hash getCodeHash() {
            return this.accountState.getCodeHash();
        }

        @Override
        public UInt256 getStorageValue(UInt256 key) {
            return this.accountState.getStorageValue(key);
        }

        @Override
        public UInt256 getOriginalStorageValue(UInt256 key) {
            return this.accountState.getOriginalStorageValue(key);
        }

        @Override
        public NavigableMap<Bytes32, AccountStorageEntry> storageEntriesFrom(Bytes32 startKeyHash, int limit) {
            return this.accountState.storageEntriesFrom(startKeyHash, limit);
        }
    }
}

