/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.branching;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.event.branching.BranchingMetrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.Threshold;
import org.hiero.consensus.concurrent.utility.throttle.RateLimitedLogger;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class DefaultBranchReporter
implements BranchReporter {
    private static final Logger logger = LogManager.getLogger(DefaultBranchReporter.class);
    private final Map<NodeId, RateLimitedLogger> nodeLoggers = new HashMap<NodeId, RateLimitedLogger>();
    private final RateLimitedLogger excessiveBranchingLogger;
    private final Roster currentRoster;
    private final Map<Long, RosterEntry> rosterMap;
    private final long rosterTotalWeight;
    private final List<NodeId> nodes = new ArrayList<NodeId>();
    private EventWindow currentEventWindow;
    private final Map<NodeId, EventDescriptorWrapper> mostRecentBranchingEvents = new HashMap<NodeId, EventDescriptorWrapper>();
    private int branchingCount;
    private long branchingWeight;
    private final BranchingMetrics metrics;

    public DefaultBranchReporter(@NonNull PlatformContext platformContext, @NonNull Roster currentRoster) {
        this.currentRoster = Objects.requireNonNull(currentRoster);
        this.rosterMap = RosterUtils.toMap((Roster)currentRoster);
        this.rosterTotalWeight = RosterUtils.computeTotalWeight((Roster)currentRoster);
        currentRoster.rosterEntries().stream().map(re -> NodeId.of((long)re.nodeId())).forEach(nodeId -> {
            this.nodes.add((NodeId)nodeId);
            this.nodeLoggers.put((NodeId)nodeId, new RateLimitedLogger(logger, platformContext.getTime(), Duration.ofMinutes(10L)));
        });
        this.excessiveBranchingLogger = new RateLimitedLogger(logger, platformContext.getTime(), Duration.ofMinutes(10L));
        Collections.sort(this.nodes);
        this.metrics = new BranchingMetrics(platformContext);
    }

    @Override
    public void reportBranch(@NonNull PlatformEvent event) {
        if (this.currentEventWindow == null) {
            throw new IllegalStateException("Event window must be set before reporting branches");
        }
        if (this.currentEventWindow.isAncient(event)) {
            return;
        }
        NodeId creator = event.getCreatorId();
        this.nodeLoggers.get(creator).error(LogMarker.EXCEPTION.getMarker(), "Node {} is branching", new Object[]{creator});
        EventDescriptorWrapper previousBranchingEvent = this.mostRecentBranchingEvents.put(creator, event.getDescriptor());
        if (previousBranchingEvent == null) {
            ++this.branchingCount;
            this.branchingWeight += this.rosterMap.get(creator.id()).weight();
        }
        this.metrics.reportBranchingEvent();
        this.metrics.reportBranchingNodeCount(this.branchingCount);
        double fraction = (double)this.branchingWeight / (double)this.rosterTotalWeight;
        this.metrics.reportBranchingWeightFraction(fraction);
        if (Threshold.STRONG_MINORITY.isSatisfiedBy(this.branchingWeight, this.rosterTotalWeight)) {
            ArrayList<NodeId> branchingNodes = new ArrayList<NodeId>();
            for (NodeId nodeId : this.nodes) {
                if (this.mostRecentBranchingEvents.get(nodeId) == null) continue;
                branchingNodes.add(nodeId);
            }
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < branchingNodes.size(); ++index) {
                sb.append(branchingNodes.get(index));
                if (index >= branchingNodes.size() - 1) continue;
                sb.append(", ");
            }
            this.excessiveBranchingLogger.fatal(LogMarker.EXCEPTION.getMarker(), "Excessive branching detected! {} weight, fraction: {}, nodes: {}", new Object[]{this.branchingWeight, fraction, sb});
        }
    }

    @Override
    public void updateEventWindow(@NonNull EventWindow eventWindow) {
        this.currentEventWindow = eventWindow;
        for (NodeId nodeId : this.nodes) {
            EventDescriptorWrapper mostRecentBranchingEvent = this.mostRecentBranchingEvents.get(nodeId);
            if (mostRecentBranchingEvent == null || !eventWindow.isAncient(mostRecentBranchingEvent)) continue;
            this.mostRecentBranchingEvents.put(nodeId, null);
            --this.branchingCount;
            this.branchingWeight -= this.rosterMap.get(nodeId.id()).weight();
        }
        this.metrics.reportBranchingNodeCount(this.branchingCount);
        this.metrics.reportBranchingWeightFraction((double)this.branchingWeight / (double)this.rosterTotalWeight);
    }

    @Override
    public void clear() {
        this.currentEventWindow = null;
        this.branchingCount = 0;
        this.branchingWeight = 0L;
        this.metrics.reportBranchingNodeCount(0);
        this.metrics.reportBranchingWeightFraction(0.0);
    }
}

