/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.Header;
import io.helidon.http.Headers;
import io.helidon.http.http2.Http2Headers;
import io.helidon.webclient.grpc.GrpcBaseClientCall;
import io.helidon.webclient.grpc.GrpcChannel;
import io.helidon.webclient.http2.StreamTimeoutException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class GrpcClientCall<ReqT, ResT>
extends GrpcBaseClientCall<ReqT, ResT> {
    private static final System.Logger LOGGER = System.getLogger(GrpcClientCall.class.getName());
    private final ExecutorService executor;
    private final Semaphore messageRequest = new Semaphore(0);
    private final LinkedBlockingQueue<BufferData> sendingQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<BufferData> receivingQueue = new LinkedBlockingQueue();
    private final CountDownLatch startReadBarrier = new CountDownLatch(1);
    private final CountDownLatch startWriteBarrier = new CountDownLatch(1);
    private volatile Future<?> readStreamFuture;
    private volatile Future<?> writeStreamFuture;
    private volatile Future<?> heartbeatFuture;

    GrpcClientCall(GrpcChannel grpcChannel, MethodDescriptor<ReqT, ResT> methodDescriptor, CallOptions callOptions) {
        super(grpcChannel, methodDescriptor, callOptions);
        this.executor = this.grpcClient().webClient().executor();
    }

    public void request(int numMessages) {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "request called %d", new Object[]{numMessages});
        this.messageRequest.release(numMessages);
        this.startReadBarrier.countDown();
    }

    public void cancel(String message, Throwable cause) {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "cancel called %s", new Object[]{message});
        this.responseListener().onClose(Status.CANCELLED, EMPTY_METADATA);
        this.readStreamFuture.cancel(true);
        this.writeStreamFuture.cancel(true);
        this.heartbeatFuture.cancel(true);
        this.close();
    }

    public void halfClose() {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "halfClose called", new Object[0]);
        this.sendingQueue.add(EMPTY_BUFFER_DATA);
        this.startWriteBarrier.countDown();
    }

    public void sendMessage(ReqT message) {
        byte[] serialized = this.serializeMessage(message);
        BufferData messageData = BufferData.createReadOnly((byte[])serialized, (int)0, (int)serialized.length);
        BufferData headerData = BufferData.create((int)5);
        headerData.writeInt8(0);
        headerData.writeUnsignedInt32((long)messageData.available());
        this.sendingQueue.add(BufferData.create((BufferData[])new BufferData[]{headerData, messageData}));
        this.startWriteBarrier.countDown();
    }

    @Override
    protected void startStreamingThreads() {
        Duration period = this.heartbeatPeriod();
        this.heartbeatFuture = !period.isZero() ? this.executor.submit(() -> {
            try {
                this.startWriteBarrier.await();
                this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Heartbeat thread] started with period " + String.valueOf(period), new Object[0]);
                while (this.isRemoteOpen()) {
                    Thread.sleep(period);
                    if (!this.sendingQueue.isEmpty()) continue;
                    this.sendingQueue.add(PING_FRAME);
                }
            }
            catch (Throwable t) {
                this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Heartbeat thread] exception " + t.getMessage(), new Object[0]);
            }
        }) : CompletableFuture.completedFuture(null);
        this.writeStreamFuture = this.executor.submit(() -> {
            try {
                this.startWriteBarrier.await();
                this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Writing thread] started", new Object[0]);
                boolean endOfStream = false;
                while (this.isRemoteOpen()) {
                    this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Writing thread] polling sending queue", new Object[0]);
                    BufferData bufferData = this.sendingQueue.poll(this.pollWaitTime().toMillis(), TimeUnit.MILLISECONDS);
                    if (bufferData == null) continue;
                    if (bufferData == PING_FRAME) {
                        this.clientStream().sendPing();
                        continue;
                    }
                    if (bufferData == EMPTY_BUFFER_DATA) {
                        if (!endOfStream) {
                            this.clientStream().writeData(EMPTY_BUFFER_DATA, true);
                        }
                        break;
                    }
                    boolean lastEndOfStream = endOfStream = this.sendingQueue.peek() == EMPTY_BUFFER_DATA;
                    this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Writing thread] writing bufferData %b", new Object[]{lastEndOfStream});
                    if (this.enableMetrics()) {
                        this.bytesSent().addAndGet(bufferData.available());
                    }
                    this.clientStream().writeData(bufferData, endOfStream);
                }
            }
            catch (Throwable e) {
                this.socket().log(LOGGER, System.Logger.Level.ERROR, e.getMessage(), e, new Object[0]);
                Status errorStatus = Status.UNKNOWN.withDescription(e.getMessage()).withCause(e);
                this.responseListener().onClose(errorStatus, EMPTY_METADATA);
            }
            this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Writing thread] exiting", new Object[0]);
        });
        this.readStreamFuture = this.executor.submit(() -> {
            try {
                Headers trailers;
                this.startReadBarrier.await();
                this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Reading thread] started", new Object[0]);
                Status status = Status.OK;
                boolean headersRead = false;
                do {
                    try {
                        Http2Headers headers = this.clientStream().readHeaders();
                        if (headers.httpHeaders().contains(STATUS_NAME)) {
                            Header grpcStatus = headers.httpHeaders().get(STATUS_NAME);
                            status = Status.fromCodeValue((int)grpcStatus.getInt());
                        }
                        headersRead = true;
                    }
                    catch (StreamTimeoutException e) {
                        this.handleStreamTimeout(e);
                    }
                } while (!headersRead);
                while (this.isRemoteOpen()) {
                    this.drainReceivingQueue();
                    if (this.clientStream().trailers().isDone() || !this.clientStream().hasEntity()) {
                        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Reading thread] trailers or eos received", new Object[0]);
                        break;
                    }
                    BufferData bufferData = this.readGrpcFrame();
                    if (bufferData == null) continue;
                    if (this.enableMetrics()) {
                        this.bytesRcvd().addAndGet(bufferData.available() - 5);
                    }
                    this.receivingQueue.add(bufferData);
                    this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Reading thread] adding bufferData to receiving queue", new Object[0]);
                }
                if (!this.receivingQueue.isEmpty()) {
                    Duration waitTime = this.grpcClient().prototype().protocolConfig().nextRequestWaitTime();
                    do {
                        if (!this.messageRequest.tryAcquire(waitTime.toNanos(), TimeUnit.NANOSECONDS)) {
                            this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Reading thread] unable to drain receiving queue", new Object[0]);
                            status = Status.CANCELLED;
                            break;
                        }
                        Object res = this.toResponse((BufferData)this.receivingQueue.remove());
                        this.responseListener().onMessage(res);
                    } while (!this.receivingQueue.isEmpty());
                }
                if (this.clientStream().trailers().isDone() && (trailers = (Headers)this.clientStream().trailers().get()).contains(STATUS_NAME)) {
                    status = Status.fromCodeValue((int)trailers.get(STATUS_NAME).getInt());
                }
                this.responseListener().onClose(status, EMPTY_METADATA);
            }
            catch (StreamTimeoutException e) {
                this.responseListener().onClose(Status.DEADLINE_EXCEEDED, EMPTY_METADATA);
            }
            catch (Throwable e) {
                this.socket().log(LOGGER, System.Logger.Level.ERROR, e.getMessage(), e, new Object[0]);
                Status errorStatus = Status.UNKNOWN.withDescription(e.getMessage()).withCause(e);
                this.responseListener().onClose(errorStatus, EMPTY_METADATA);
            }
            finally {
                this.close();
            }
            this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Reading thread] exiting", new Object[0]);
        });
    }

    private void close() {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "closing client call", new Object[0]);
        this.sendingQueue.clear();
        this.clientStream().cancel();
        this.connection().close();
        this.unblockUnaryExecutor();
        if (this.enableMetrics()) {
            GrpcBaseClientCall.MethodMetrics methodMetrics = this.methodMetrics();
            methodMetrics.callDuration().record(Duration.ofMillis(System.currentTimeMillis() - this.startMillis()));
            methodMetrics.recvMessageSize().record((double)this.bytesRcvd().get());
            methodMetrics.sentMessageSize().record((double)this.bytesSent().get());
        }
    }

    private void drainReceivingQueue() {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Reading thread] draining receiving queue", new Object[0]);
        while (!this.receivingQueue.isEmpty() && this.messageRequest.tryAcquire()) {
            Object res = this.toResponse((BufferData)this.receivingQueue.remove());
            this.responseListener().onMessage(res);
        }
    }
}

