/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.roster.impl;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.node.app.service.roster.impl.schemas.V0540RosterSchema;
import com.hedera.node.app.spi.migrate.StartupNetworks;
import com.hedera.node.internal.network.Network;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.lifecycle.Service;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hiero.consensus.roster.RosterUtils;
import org.hiero.consensus.roster.WritableRosterStore;

public class RosterServiceImpl
implements Service {
    public static final int MIGRATION_ORDER = -1;
    public static final String NAME = "RosterService";
    private final Predicate<Roster> canAdopt;
    private final BiConsumer<Roster, Roster> onAdopt;
    @Deprecated
    private final Supplier<State> stateSupplier;
    private final Supplier<StartupNetworks> startupNetworks;

    public RosterServiceImpl(@NonNull Predicate<Roster> canAdopt, @NonNull BiConsumer<Roster, Roster> onAdopt, @NonNull Supplier<State> stateSupplier, @NonNull Supplier<StartupNetworks> startupNetworks) {
        this.onAdopt = Objects.requireNonNull(onAdopt);
        this.canAdopt = Objects.requireNonNull(canAdopt);
        this.stateSupplier = Objects.requireNonNull(stateSupplier);
        this.startupNetworks = Objects.requireNonNull(startupNetworks);
    }

    @NonNull
    public String getServiceName() {
        return NAME;
    }

    public int migrationOrder() {
        return -1;
    }

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        Objects.requireNonNull(registry);
        registry.register((Schema)new V0540RosterSchema(this.onAdopt, this.canAdopt, WritableRosterStore::new));
    }

    public boolean doGenesisSetup(@NonNull WritableStates writableStates, @NonNull Configuration configuration) {
        Objects.requireNonNull(writableStates);
        Objects.requireNonNull(configuration);
        WritableRosterStore rosterStore = new WritableRosterStore(writableStates);
        Network genesisNetwork = this.startupNetworks.get().genesisNetworkOrThrow(configuration);
        rosterStore.putActiveRoster(RosterUtils.rosterFrom((Network)genesisNetwork), 0L);
        return true;
    }
}

