/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import org.hiero.base.utility.Threshold;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class RosterLookup {
    private final Roster roster;
    private final long rosterTotalWeight;
    private final boolean nodeHasSupermajorityWeight;
    private final Map<Long, Integer> rosterIndicesMap;

    public RosterLookup(@NonNull Roster roster) {
        this.roster = roster;
        this.rosterTotalWeight = RosterUtils.computeTotalWeight(roster);
        this.rosterIndicesMap = RosterUtils.toIndicesMap(roster);
        long maxWeight = roster.rosterEntries().stream().mapToLong(RosterEntry::weight).max().orElse(0L);
        this.nodeHasSupermajorityWeight = Threshold.SUPER_MAJORITY.isSatisfiedBy(maxWeight, this.rosterTotalWeight);
    }

    @NonNull
    public Roster getRoster() {
        return this.roster;
    }

    public long rosterTotalWeight() {
        return this.rosterTotalWeight;
    }

    public boolean nodeHasSupermajorityWeight() {
        return this.nodeHasSupermajorityWeight;
    }

    public int numMembers() {
        return this.roster.rosterEntries().size();
    }

    public boolean isIdAtIndex(@NonNull NodeId nodeId, int index) {
        if (index < 0 || index >= this.roster.rosterEntries().size()) {
            return false;
        }
        return ((RosterEntry)this.roster.rosterEntries().get(index)).nodeId() == nodeId.id();
    }

    public long getWeight(@NonNull NodeId nodeId) {
        Integer index = this.rosterIndicesMap.get(nodeId.id());
        if (index == null) {
            return 0L;
        }
        RosterEntry entry = (RosterEntry)this.roster.rosterEntries().get(index);
        if (entry == null) {
            return 0L;
        }
        return entry.weight();
    }

    public long getWeight(int nodeIndex) {
        return ((RosterEntry)this.roster.rosterEntries().get(nodeIndex)).weight();
    }

    public int getRosterIndex(@NonNull NodeId nodeId) {
        Integer index = this.rosterIndicesMap.get(nodeId.id());
        if (index == null) {
            throw new IllegalArgumentException("Node ID not found in roster: " + nodeId.id());
        }
        return index;
    }
}

