/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

final class Qualifiers {
    private Qualifiers() {
    }

    static boolean matchesQualifiers(Collection<Qualifier> src, Collection<Qualifier> criteria) {
        if (criteria.isEmpty()) {
            return true;
        }
        if (criteria.size() == 1 && criteria.contains(Qualifier.WILDCARD_NAMED)) {
            return true;
        }
        if (src.isEmpty()) {
            return false;
        }
        if (src.contains(Qualifier.WILDCARD_NAMED) && criteria.stream().allMatch(it -> it.typeName().equals((Object)Service.Named.TYPE))) {
            return true;
        }
        for (Qualifier criteriaQualifier : criteria) {
            if (src.contains(criteriaQualifier)) continue;
            if (criteriaQualifier.typeName().equals((Object)Service.Named.TYPE)) {
                boolean hasSameTypeAsCriteria;
                if (criteriaQualifier.equals(Qualifier.WILDCARD_NAMED) || criteriaQualifier.value().isEmpty() ? (hasSameTypeAsCriteria = src.stream().anyMatch(q -> q.typeName().equals((Object)criteriaQualifier.typeName()))) : src.contains(Qualifier.WILDCARD_NAMED)) continue;
                return false;
            }
            if (criteriaQualifier.value().isEmpty()) {
                Set sameTypeAsCriteriaSet = src.stream().filter(q -> q.typeName().equals((Object)criteriaQualifier.typeName())).collect(Collectors.toSet());
                if (!sameTypeAsCriteriaSet.isEmpty()) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

