/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.UnitType;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.function.IntUnaryOperator;

public final class ArrayType<ET extends ABIType<E>, E, A>
extends ABIType<A> {
    static final Class<String> STRING_CLASS = String.class;
    static final Class<String[]> STRING_ARRAY_CLASS = String[].class;
    static final int MAX_LEN = 0x7FFFFFF1;
    public static final int DYNAMIC_LENGTH = -1;
    private final ET elementType;
    private final Class<?> arrayClass;
    private final int length;
    private final int headLength;
    private final int flags;

    ArrayType(String canonicalType, Class<A> clazz, ET elementType, int length, Class<?> arrayClass, int flags) {
        super(canonicalType, clazz, -1 == length || ((ABIType)elementType).dynamic);
        this.elementType = elementType;
        this.length = length;
        this.arrayClass = arrayClass;
        this.headLength = this.dynamic ? 32 : this.staticArrayHeadLength();
        this.flags = flags;
    }

    private int staticArrayHeadLength() {
        switch (((ABIType)this.elementType).typeCode()) {
            case 1: {
                return 32;
            }
            case 6: {
                return this.length * super.staticArrayHeadLength();
            }
            case 7: {
                return this.length * ((ABIType)this.elementType).asTupleType().headLengthSum;
            }
        }
        return this.length * 32;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public ET getElementType() {
        return this.elementType;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isString() {
        return STRING_CLASS == this.clazz;
    }

    @Override
    Class<?> arrayClass() {
        if (this.arrayClass != null) {
            return this.arrayClass;
        }
        return ArrayType.createArray(this.clazz, 0).getClass();
    }

    @Override
    public int typeCode() {
        return 6;
    }

    @Override
    int headLength() {
        return this.headLength;
    }

    @Override
    int dynamicByteLength(A value) {
        return TupleType.totalLen(this.calcElementsLen(value), this.length == -1);
    }

    @Override
    int byteLength(A value) {
        if (!this.dynamic) {
            return this.headLength;
        }
        return this.dynamicByteLength(value);
    }

    private int calcElementsLen(A value) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return ((boolean[])value).length * 32;
            }
            case 1: {
                return Integers.roundLengthUp(this.byteCount(value), 32);
            }
            case 2: {
                return ((int[])value).length * 32;
            }
            case 3: {
                return ((long[])value).length * 32;
            }
            case 4: 
            case 5: 
            case 8: {
                return ((Object[])value).length * 32;
            }
            case 6: 
            case 7: {
                return this.measureByteLength((Object[])value);
            }
        }
        throw new AssertionError();
    }

    private int staticByteLengthPacked() {
        if (this.length == -1) {
            throw new IllegalArgumentException("array of dynamic elements");
        }
        return this.length * (this.elementType instanceof UnitType ? 32 : ((ABIType)this.elementType).byteLengthPacked(null));
    }

    @Override
    int byteLengthPacked(A value) {
        if (value == null) {
            return this.staticByteLengthPacked();
        }
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return ((boolean[])value).length * 32;
            }
            case 1: {
                return this.byteCount(value);
            }
            case 2: {
                return ((int[])value).length * 32;
            }
            case 3: {
                return ((long[])value).length * 32;
            }
            case 4: 
            case 5: 
            case 8: {
                return ((Object[])value).length * 32;
            }
            case 6: 
            case 7: {
                return this.measureByteLengthPacked((Object[])value);
            }
        }
        throw new AssertionError();
    }

    private int byteCount(Object value) {
        return this.decodeIfString(value).length;
    }

    private byte[] decodeIfString(Object value) {
        return !this.isString() ? (byte[])value : Strings.decode((String)value, 1);
    }

    Object encodeIfString(byte[] bytes) {
        return !this.isString() ? bytes : (byte[])Strings.encode(bytes, 1);
    }

    @Override
    public int validate(A value) {
        this.validateClass(value);
        return TupleType.totalLen(this.validateElements(value), this.length == -1);
    }

    private int validateElements(A value) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return this.validateBooleans((boolean[])value);
            }
            case 1: {
                return this.validateBytes(value);
            }
            case 2: {
                return this.validateInts((int[])value, (IntType)this.elementType);
            }
            case 3: {
                return this.validateLongs((long[])value, (LongType)this.elementType);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.validateObjects((Object[])value);
            }
        }
        throw new AssertionError();
    }

    private int validateBooleans(boolean[] arr) {
        return this.checkLength(arr.length, arr) * 32;
    }

    private int validateBytes(A arr) {
        return Integers.roundLengthUp(this.checkLength(this.byteCount(arr), arr), 32);
    }

    private int measureArrayElements(int n, IntUnaryOperator measurer) {
        int elementsLength = TupleType.countBytes(false, n, measurer);
        return ((ABIType)this.elementType).dynamic ? 32 * n + elementsLength : elementsLength;
    }

    private int validateInts(int[] arr, IntType type) {
        return this.measureArrayElements(this.checkLength(arr.length, arr), i -> type.validatePrimitive(arr[i]));
    }

    private int validateLongs(long[] arr, LongType type) {
        return this.measureArrayElements(this.checkLength(arr.length, arr), i -> type.validatePrimitive(arr[i]));
    }

    private int validateObjects(E[] arr) {
        return this.measureArrayElements(this.checkLength(arr.length, arr), i -> ((ABIType)this.elementType).validate((Object)arr[i]));
    }

    private int measureByteLength(E[] arr) {
        return this.measureArrayElements(arr.length, i -> ((ABIType)this.elementType).byteLength((Object)arr[i]));
    }

    private int measureByteLengthPacked(E[] arr) {
        return TupleType.countBytes(false, arr.length, i -> ((ABIType)this.elementType).byteLengthPacked((Object)arr[i]));
    }

    private int checkLength(int valueLen, Object value) {
        if (this.length != -1 && this.length != valueLen) {
            throw this.mismatchErr("array length", ArrayType.simpleName(value.getClass(), valueLen), ArrayType.simpleName(this.clazz, this.length), "length " + this.length, "" + valueLen);
        }
        return valueLen;
    }

    private static String simpleName(Class<?> clazz, int arrayLen) {
        String name = clazz.getSimpleName();
        int index = name.indexOf("[]") + 1;
        return index != 0 ? name.substring(0, index) + arrayLen + name.substring(index) : name;
    }

    @Override
    void encodeTail(A value, ByteBuffer dest) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                this.encodeBooleans((boolean[])value, dest);
                return;
            }
            case 1: {
                this.encodeBytes(this.decodeIfString(value), dest);
                return;
            }
            case 2: {
                this.encodeInts((int[])value, dest);
                return;
            }
            case 3: {
                this.encodeLongs((long[])value, dest);
                return;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.encodeObjects((Object[])value, dest);
                return;
            }
        }
        throw new AssertionError();
    }

    private void encodeObjects(E[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        if (((ABIType)this.elementType).dynamic) {
            this.encodeDynamic(arr, dest, 32 * arr.length);
        } else {
            this.encodeStatic(arr, dest);
        }
    }

    private void encodeStatic(E[] values, ByteBuffer dest) {
        for (E value : values) {
            ((ABIType)this.elementType).encodeTail(value, dest);
        }
    }

    private void encodeDynamic(E[] values, ByteBuffer dest, int offset) {
        if (values.length == 0) {
            return;
        }
        int last = values.length - 1;
        int i = 0;
        while (true) {
            ArrayType.insertIntUnsigned(offset, dest);
            if (i == last) {
                for (E value : values) {
                    ((ABIType)this.elementType).encodeTail(value, dest);
                }
                return;
            }
            offset += ((ABIType)this.elementType).dynamicByteLength(values[i]);
            ++i;
        }
    }

    private void encodeArrayLen(int len, ByteBuffer dest) {
        if (this.length == -1) {
            ArrayType.insertIntUnsigned(len, dest);
        }
    }

    private void encodeBooleans(boolean[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        for (boolean e : arr) {
            BooleanType.encodeBoolean(e, dest);
        }
    }

    private void encodeBytes(byte[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        dest.put(arr);
        int rem = Integers.mod(arr.length, 32);
        ArrayType.insert00Padding(rem != 0 ? 32 - rem : 0, dest);
    }

    private void encodeInts(int[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        for (int e : arr) {
            ArrayType.insertInt(e, dest);
        }
    }

    private void encodeLongs(long[] arr, ByteBuffer dest) {
        this.encodeArrayLen(arr.length, dest);
        for (long e : arr) {
            ArrayType.insertInt(e, dest);
        }
    }

    @Override
    void encodePackedUnchecked(A value, ByteBuffer dest) {
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                ArrayType.encodeBooleansPacked((boolean[])value, dest);
                return;
            }
            case 1: {
                dest.put(this.decodeIfString(value));
                return;
            }
            case 2: {
                ArrayType.encodeIntsPacked((int[])value, (IntType)this.elementType, dest);
                return;
            }
            case 3: {
                ArrayType.encodeLongsPacked((long[])value, (LongType)this.elementType, dest);
                return;
            }
            case 4: 
            case 5: 
            case 8: {
                this.encodeElementsPacked((Object[])value, dest);
                return;
            }
            case 6: 
            case 7: {
                for (Object e : (Object[])value) {
                    ((ABIType)this.elementType).encodePackedUnchecked((Object)e, dest);
                }
                return;
            }
        }
        throw new AssertionError();
    }

    private void encodeElementsPacked(E[] elements, ByteBuffer dest) {
        for (E e : elements) {
            ((ABIType)this.elementType).encode(e, dest);
        }
    }

    private static void encodeBooleansPacked(boolean[] arr, ByteBuffer dest) {
        for (boolean bool : arr) {
            BooleanType.encodeBoolean(bool, dest);
        }
    }

    private static void encodeIntsPacked(int[] arr, IntType elementType, ByteBuffer dest) {
        for (int e : arr) {
            elementType.encode(e, dest);
        }
    }

    private static void encodeLongsPacked(long[] arr, LongType elementType, ByteBuffer dest) {
        for (long e : arr) {
            elementType.encode(e, dest);
        }
    }

    @Override
    A decode(ByteBuffer bb, byte[] unitBuffer) {
        int arrayLen = this.length == -1 ? IntType.UINT21.decode(bb, unitBuffer) : this.length;
        this.checkNoDecodePossible(bb.remaining(), arrayLen);
        switch (((ABIType)this.elementType).typeCode()) {
            case 0: {
                return (A)ArrayType.decodeBooleans(arrayLen, bb, unitBuffer);
            }
            case 1: {
                return (A)this.encodeIfString(ArrayType.decodeBytes(arrayLen, bb, (this.flags & 1) != 0));
            }
            case 2: {
                return (A)ArrayType.decodeInts(arrayLen, bb, (IntType)this.elementType, unitBuffer);
            }
            case 3: {
                return (A)ArrayType.decodeLongs(arrayLen, bb, (LongType)this.elementType, unitBuffer);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return (A)this.decodeObjects(arrayLen, bb, unitBuffer);
            }
        }
        throw new AssertionError();
    }

    private void checkNoDecodePossible(int remaining, int arrayLen) {
        int minByteLen;
        int n = !this.dynamic ? this.headLength : (((ABIType)this.elementType).dynamic ? arrayLen * 32 : (!(this.elementType instanceof ByteType) ? arrayLen * ((ABIType)this.elementType).headLength() : (minByteLen = (this.flags & 1) != 0 ? arrayLen : Integers.roundLengthUp(arrayLen, 32))));
        if (remaining < minByteLen) {
            throw new IllegalArgumentException("not enough bytes remaining: " + remaining + " < " + minByteLen);
        }
    }

    private static boolean[] decodeBooleans(int len, ByteBuffer bb, byte[] unitBuffer) {
        int i;
        boolean[] booleans = new boolean[len];
        try {
            for (i = 0; i < len; ++i) {
                booleans[i] = BooleanType.INSTANCE.decode(bb, unitBuffer);
            }
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.exceptionWithIndex(false, i, cause);
        }
        return booleans;
    }

    private static byte[] decodeBytes(int len, ByteBuffer bb, boolean legacyDecode) {
        byte[] data = new byte[len];
        bb.get(data);
        if (!legacyDecode) {
            int bytes;
            for (bytes = -len & 0x1F; bytes >= 8; bytes -= 8) {
                if (bb.getLong() == 0L) continue;
                throw new IllegalArgumentException("malformed array: non-zero padding byte");
            }
            while (bytes != 0) {
                if (bb.get() != 0) {
                    throw new IllegalArgumentException("malformed array: non-zero padding byte");
                }
                --bytes;
            }
        }
        return data;
    }

    private static int[] decodeInts(int len, ByteBuffer bb, IntType intType, byte[] unitBuffer) {
        int i;
        int[] ints = new int[len];
        try {
            for (i = 0; i < len; ++i) {
                ints[i] = intType.decode(bb, unitBuffer);
            }
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.exceptionWithIndex(false, i, cause);
        }
        return ints;
    }

    private static long[] decodeLongs(int len, ByteBuffer bb, LongType longType, byte[] unitBuffer) {
        int i;
        long[] longs = new long[len];
        try {
            for (i = 0; i < len; ++i) {
                longs[i] = longType.decode(bb, unitBuffer);
            }
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.exceptionWithIndex(false, i, cause);
        }
        return longs;
    }

    static <T> T[] createArray(Class<T> elementClass, int len) {
        return (Object[])Array.newInstance(elementClass, len);
    }

    private E[] decodeObjects(int len, ByteBuffer bb, byte[] unitBuffer) {
        int i;
        J[] elements = ArrayType.createArray(((ABIType)this.elementType).clazz, len);
        try {
            if (!((ABIType)this.elementType).dynamic) {
                for (i = 0; i < elements.length; ++i) {
                    elements[i] = ((ABIType)this.elementType).decode(bb, unitBuffer);
                }
            } else {
                int start;
                int saved = start = bb.position();
                while (i < elements.length) {
                    bb.position(saved);
                    int jump = start + IntType.UINT30.decode(bb, unitBuffer);
                    saved = bb.position();
                    bb.position(jump);
                    elements[i] = ((ABIType)this.elementType).decode(bb, unitBuffer);
                    ++i;
                }
            }
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.exceptionWithIndex(false, i, cause);
        }
        return elements;
    }

    public static <T extends ABIType<?>> T baseType(ABIType<?> type) {
        return (T)(type instanceof ArrayType ? ArrayType.baseType(type.asArrayType().getElementType()) : type);
    }
}

