/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli;

import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.platform.config.DefaultConfiguration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.hiero.consensus.config.EventConfig;
import org.hiero.consensus.pcli.AbstractCommand;
import org.hiero.consensus.pcli.Pcli;
import org.hiero.consensus.pcli.SubcommandOf;
import picocli.CommandLine;

@CommandLine.Command(name="clean", mixinStandardHelpOptions=true, description={"Delete all files generated by running the platform."})
@SubcommandOf(value=Pcli.class)
public final class CleanCommand
extends AbstractCommand {
    private Path sdkPath;

    @CommandLine.Parameters(description={"the path to the sdk directory"})
    private void setSdkPath(Path sdkPath) {
        this.sdkPath = this.dirMustExist(sdkPath.toAbsolutePath());
    }

    @Override
    public Integer call() throws Exception {
        CleanCommand.clean(this.sdkPath);
        return 0;
    }

    public static void clean(@NonNull Path sdkPath) throws IOException {
        Objects.requireNonNull(sdkPath);
        Configuration configuration = DefaultConfiguration.buildBasicConfiguration((ConfigurationBuilder)ConfigurationBuilder.create(), (Path)sdkPath.resolve("settings.txt"));
        FileUtils.deleteFiles((Path)sdkPath, (String)".log");
        FileUtils.deleteFiles((Path)sdkPath, (String)".csv");
        FileUtils.deleteFiles((Path)sdkPath, (String)"metricsDoc.tsv");
        FileUtils.deleteFiles((Path)sdkPath, (String)"settingsUsed.txt");
        FileUtils.deleteDirectory((Path)sdkPath.resolve(((StateCommonConfig)configuration.getConfigData(StateCommonConfig.class)).savedStateDirectory()));
        FileUtils.deleteDirectory((Path)sdkPath.resolve(((EventConfig)configuration.getConfigData(EventConfig.class)).eventsLogDir()));
    }
}

