/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.protocol;

import com.swirlds.base.time.Time;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.hiero.base.CompareTo;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.gossip.impl.network.NetworkMetrics;
import org.hiero.consensus.gossip.impl.network.NetworkProtocolException;
import org.hiero.consensus.gossip.impl.network.protocol.PeerProtocol;
import org.hiero.consensus.model.node.NodeId;

public class HeartbeatPeerProtocol
implements PeerProtocol {
    private final NodeId peerId;
    private Instant lastHeartbeatTime = Instant.MIN;
    private final Duration heartbeatPeriod;
    private final NetworkMetrics networkMetrics;
    private final Time time;

    public HeartbeatPeerProtocol(@NonNull NodeId peerId, @NonNull Duration heartbeatPeriod, @NonNull NetworkMetrics networkMetrics, @NonNull Time time) {
        this.peerId = Objects.requireNonNull(peerId);
        this.heartbeatPeriod = Objects.requireNonNull(heartbeatPeriod);
        this.networkMetrics = Objects.requireNonNull(networkMetrics);
        this.time = Objects.requireNonNull(time);
    }

    @Override
    public boolean shouldInitiate() {
        Duration elapsed = Duration.between(this.lastHeartbeatTime, this.time.now());
        return CompareTo.isGreaterThanOrEqualTo((Comparable)elapsed, (Object)this.heartbeatPeriod);
    }

    @Override
    public boolean shouldAccept() {
        return true;
    }

    @Override
    public boolean acceptOnSimultaneousInitiate() {
        return true;
    }

    private long initiateHeartbeat(@NonNull Connection connection) throws IOException, NetworkProtocolException {
        connection.getDos().write(64);
        connection.getDos().flush();
        long startTime = this.time.nanoTime();
        byte readByte = connection.getDis().readByte();
        if (readByte != 64) {
            throw new NetworkProtocolException(String.format("received %02x but expected %02x (HEARTBEAT)", readByte, (byte)64));
        }
        return startTime;
    }

    private long acknowledgeHeartbeat(@NonNull Connection connection) throws IOException, NetworkProtocolException {
        connection.getDos().write(65);
        connection.getDos().flush();
        byte readByte = connection.getDis().readByte();
        if (readByte != 65) {
            throw new NetworkProtocolException(String.format("received %02x but expected %02x (HEARTBEAT_ACK)", readByte, (byte)65));
        }
        return this.time.nanoTime();
    }

    @Override
    public void runProtocol(@NonNull Connection connection) throws NetworkProtocolException, IOException, InterruptedException {
        this.lastHeartbeatTime = this.time.now();
        long startTime = this.initiateHeartbeat(connection);
        long endTime = this.acknowledgeHeartbeat(connection);
        this.networkMetrics.recordPingTime(this.peerId, endTime - startTime);
    }
}

