/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ObjectShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortObjectMap;
import org.eclipse.collections.api.map.primitive.ObjectShortMap;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ObjectShortPair;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.ObjectShortMaps;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.factory.primitive.ShortObjectMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableObjectShortMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectShortEmptyMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectShortHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableObjectShortSingletonMap<K>
extends AbstractImmutableObjectShortMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_VALUE = 0;
    private final K key1;
    private final short value1;

    ImmutableObjectShortSingletonMap(K key1, short value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)ObjectShortHashMap.newWithKeysValues(this.key1, this.value1).shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableShortCollection select(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? ShortLists.immutable.with(this.value1) : ShortLists.immutable.with();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? ShortLists.immutable.with() : ShortLists.immutable.with(this.value1);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with((Object)ShortLists.immutable.with(this.value1));
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public long sum() {
        return this.value1;
    }

    public short min() {
        return this.value1;
    }

    public short max() {
        return this.value1;
    }

    public short maxIfEmpty(short defaultValue) {
        return this.value1;
    }

    public short minIfEmpty(short defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public short[] toSortedArray() {
        return new short[]{this.value1};
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newListWith(this.value1);
    }

    public short[] toArray() {
        return new short[]{this.value1};
    }

    public short[] toArray(short[] target) {
        if (target.length < 1) {
            target = new short[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    public boolean contains(short value) {
        return this.value1 == value;
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableShortList toList() {
        return ShortArrayList.newListWith(this.value1);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSetWith(this.value1);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBagWith(this.value1);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public ImmutableObjectShortMap<K> newWithKeyValue(K key, short value) {
        return ObjectShortMaps.immutable.withAll(ObjectShortHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableObjectShortMap<K> newWithoutKey(K key) {
        return ImmutableObjectShortSingletonMap.nullSafeEquals(this.key1, key) ? ImmutableObjectShortEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public ImmutableObjectShortMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectShortHashMap<K> map = new ObjectShortHashMap<K>(this);
        for (K key : keys) {
            map.removeKey(key);
        }
        return map.toImmutable();
    }

    public short get(Object key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getOrThrow(Object key) {
        if (ImmutableObjectShortSingletonMap.nullSafeEquals(this.key1, key)) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public short getIfAbsent(Object key, short ifAbsent) {
        return ImmutableObjectShortSingletonMap.nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    public boolean containsKey(Object key) {
        return ImmutableObjectShortSingletonMap.nullSafeEquals(this.key1, key);
    }

    public boolean containsValue(short value) {
        return this.value1 == value;
    }

    public void forEachValue(ShortProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ObjectShortProcedure<? super K> objectShortProcedure) {
        objectShortProcedure.value(this.key1, this.value1);
    }

    public boolean allSatisfyKeyValue(ObjectShortPredicate<K> predicate) {
        return predicate.accept(this.key1, this.value1);
    }

    public ImmutableObjectShortMap<K> select(ObjectShortPredicate<? super K> objectShortPredicate) {
        return objectShortPredicate.accept(this.key1, this.value1) ? ObjectShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : ImmutableObjectShortEmptyMap.INSTANCE;
    }

    public ImmutableObjectShortMap<K> reject(ObjectShortPredicate<? super K> objectShortPredicate) {
        return objectShortPredicate.accept(this.key1, this.value1) ? ImmutableObjectShortEmptyMap.INSTANCE : ObjectShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableObjectShortMap<K> toImmutable() {
        return this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public Set<K> keySet() {
        return Sets.immutable.of(this.key1).castToSet();
    }

    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of((MutableShortCollection)ShortArrayList.newListWith(this.value1));
    }

    public LazyIterable<K> keysView() {
        return Lists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ObjectShortPair<K>> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableShortObjectMap<K> flipUniqueValues() {
        return ShortObjectMaps.immutable.with(this.value1, this.key1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectShortMap)) {
            return false;
        }
        ObjectShortMap map = (ObjectShortMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectShortMap.ImmutableObjectShortMapSerializationProxy(this);
    }
}

