/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.webserver.ProtocolConfigs;
import io.helidon.webserver.http2.Http2Config;
import io.helidon.webserver.http2.Http2ConnectionSelector;
import io.helidon.webserver.http2.spi.Http2SubProtocolProvider;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import io.helidon.webserver.spi.ProtocolConfig;
import io.helidon.webserver.spi.ServerConnectionSelector;
import io.helidon.webserver.spi.ServerConnectionSelectorProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class Http2ConnectionProvider
implements ServerConnectionSelectorProvider<Http2Config> {
    static final String CONFIG_NAME = "http_2";
    private final List<Http2SubProtocolProvider> subProtocolProviders = HelidonServiceLoader.create(ServiceLoader.load(Http2SubProtocolProvider.class)).asList();

    @Deprecated
    public Http2ConnectionProvider() {
    }

    public Class<Http2Config> protocolConfigType() {
        return Http2Config.class;
    }

    public String protocolType() {
        return CONFIG_NAME;
    }

    public ServerConnectionSelector create(String listenerName, Http2Config config, ProtocolConfigs configs) {
        ArrayList<Http2SubProtocolSelector> subProtocolSelectors = new ArrayList<Http2SubProtocolSelector>();
        for (Http2SubProtocolProvider subProtocolProvider : this.subProtocolProviders) {
            List providerConfigs = configs.config(subProtocolProvider.protocolType(), subProtocolProvider.protocolConfigType());
            for (ProtocolConfig providerConfig : providerConfigs) {
                subProtocolSelectors.add(subProtocolProvider.create(providerConfig, configs));
            }
        }
        return new Http2ConnectionSelector(config, subProtocolSelectors);
    }
}

