/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.cryptography.wraps.Proof;
import com.hedera.cryptography.wraps.SchnorrKeys;
import com.hedera.cryptography.wraps.WRAPSLibraryBridge;
import com.hedera.cryptography.wraps.WRAPSVerificationKey;
import com.hedera.node.app.history.HistoryLibrary;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import java.util.SplittableRandom;

public class HistoryLibraryImpl
implements HistoryLibrary {
    public static final SplittableRandom RANDOM = new SplittableRandom();
    public static final WRAPSLibraryBridge WRAPS = WRAPSLibraryBridge.getInstance();

    @Override
    public byte[] wrapsVerificationKey() {
        return WRAPSVerificationKey.getCurrentKey();
    }

    @Override
    public SchnorrKeys newSchnorrKeyPair() {
        byte[] seed = new byte[32];
        RANDOM.nextBytes(seed);
        return WRAPS.generateSchnorrKeys(seed);
    }

    @Override
    public byte[] hashAddressBook(@NonNull HistoryLibrary.AddressBook addressBook) {
        Objects.requireNonNull(addressBook);
        return WRAPS.hashAddressBook(addressBook.publicKeys(), addressBook.weights(), addressBook.nodeIds());
    }

    @Override
    public byte[] computeWrapsMessage(@NonNull HistoryLibrary.AddressBook addressBook, @NonNull byte[] hintsVerificationKey) {
        Objects.requireNonNull(addressBook);
        Objects.requireNonNull(hintsVerificationKey);
        return WRAPS.formatRotationMessage(addressBook.publicKeys(), addressBook.weights(), addressBook.nodeIds(), hintsVerificationKey);
    }

    @Override
    public byte[] runWrapsPhaseR1(@NonNull byte[] entropy, @NonNull byte[] message, @NonNull byte[] privateKey) {
        Objects.requireNonNull(entropy);
        Objects.requireNonNull(message);
        Objects.requireNonNull(privateKey);
        return WRAPS.runSigningProtocolPhase(WRAPSLibraryBridge.SigningProtocolPhase.R1, entropy, message, privateKey, (byte[][])new byte[0][], null, null, null, (byte[][])new byte[0][], (byte[][])new byte[0][], (byte[][])new byte[0][]);
    }

    @Override
    public byte[] runWrapsPhaseR2(@NonNull byte[] entropy, @NonNull byte[] message, @NonNull byte[][] r1Messages, @NonNull byte[] privateKey, @NonNull HistoryLibrary.AddressBook currentBook, @NonNull Set<Long> r1NodeIds) {
        Objects.requireNonNull(entropy);
        Objects.requireNonNull(message);
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(r1Messages);
        Objects.requireNonNull(currentBook);
        Objects.requireNonNull(r1NodeIds);
        return WRAPS.runSigningProtocolPhase(WRAPSLibraryBridge.SigningProtocolPhase.R2, entropy, message, privateKey, currentBook.publicKeys(), currentBook.weights(), currentBook.nodeIds(), currentBook.signersMask(r1NodeIds), r1Messages, (byte[][])new byte[0][], (byte[][])new byte[0][]);
    }

    @Override
    public byte[] runWrapsPhaseR3(@NonNull byte[] entropy, @NonNull byte[] message, @NonNull byte[][] r1Messages, @NonNull byte[][] r2Messages, @NonNull byte[] privateKey, @NonNull HistoryLibrary.AddressBook currentBook, @NonNull Set<Long> r1NodeIds) {
        Objects.requireNonNull(entropy);
        Objects.requireNonNull(message);
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(r1Messages);
        Objects.requireNonNull(r2Messages);
        Objects.requireNonNull(currentBook);
        Objects.requireNonNull(r1NodeIds);
        return WRAPS.runSigningProtocolPhase(WRAPSLibraryBridge.SigningProtocolPhase.R3, entropy, message, privateKey, currentBook.publicKeys(), currentBook.weights(), currentBook.nodeIds(), currentBook.signersMask(r1NodeIds), r1Messages, r2Messages, (byte[][])new byte[0][]);
    }

    @Override
    public byte[] runAggregationPhase(@NonNull byte[] message, @NonNull byte[][] r1Messages, @NonNull byte[][] r2Messages, @NonNull byte[][] r3Messages, @NonNull HistoryLibrary.AddressBook currentBook, @NonNull Set<Long> r1NodeIds) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(r1Messages);
        Objects.requireNonNull(r2Messages);
        Objects.requireNonNull(r3Messages);
        Objects.requireNonNull(currentBook);
        Objects.requireNonNull(r1NodeIds);
        return WRAPS.runSigningProtocolPhase(WRAPSLibraryBridge.SigningProtocolPhase.Aggregate, null, message, null, currentBook.publicKeys(), currentBook.weights(), currentBook.nodeIds(), currentBook.signersMask(r1NodeIds), r1Messages, r2Messages, r3Messages);
    }

    @Override
    public boolean verifyAggregateSignature(@NonNull byte[] message, @NonNull long[] nodeIds, @NonNull byte[][] publicKeys, @NonNull long[] weights, @NonNull byte[] signature) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(publicKeys);
        Objects.requireNonNull(signature);
        Objects.requireNonNull(nodeIds);
        Objects.requireNonNull(weights);
        return WRAPS.verifySignature(publicKeys, weights, nodeIds, message, signature);
    }

    @Override
    public Proof constructGenesisWrapsProof(@NonNull byte[] genesisAddressBookHash, @NonNull byte[] genesisHintsVerificationKey, @NonNull byte[] aggregatedSignature, @NonNull Set<Long> signers, @NonNull HistoryLibrary.AddressBook addressBook) {
        Objects.requireNonNull(genesisAddressBookHash);
        Objects.requireNonNull(genesisHintsVerificationKey);
        Objects.requireNonNull(aggregatedSignature);
        Objects.requireNonNull(signers);
        Objects.requireNonNull(addressBook);
        return WRAPS.constructWrapsProof(genesisAddressBookHash, addressBook.publicKeys(), addressBook.weights(), addressBook.nodeIds(), addressBook.publicKeys(), addressBook.weights(), addressBook.nodeIds(), null, genesisHintsVerificationKey, aggregatedSignature);
    }

    @Override
    public Proof constructIncrementalWrapsProof(@NonNull byte[] genesisAddressBookHash, @NonNull byte[] sourceProof, @NonNull HistoryLibrary.AddressBook sourceAddressBook, @NonNull HistoryLibrary.AddressBook targetAddressBook, @NonNull byte[] targetHintsVerificationKey, @NonNull byte[] aggregatedSignature, @NonNull Set<Long> signers) {
        Objects.requireNonNull(genesisAddressBookHash);
        Objects.requireNonNull(sourceProof);
        Objects.requireNonNull(sourceAddressBook);
        Objects.requireNonNull(targetAddressBook);
        Objects.requireNonNull(targetHintsVerificationKey);
        Objects.requireNonNull(aggregatedSignature);
        Objects.requireNonNull(signers);
        return WRAPS.constructWrapsProof(genesisAddressBookHash, sourceAddressBook.publicKeys(), sourceAddressBook.weights(), sourceAddressBook.nodeIds(), targetAddressBook.publicKeys(), targetAddressBook.weights(), targetAddressBook.nodeIds(), sourceProof, targetHintsVerificationKey, aggregatedSignature);
    }

    @Override
    public boolean wrapsProverReady() {
        return WRAPSLibraryBridge.isProofSupported();
    }
}

