/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.signature;

import com.hedera.hapi.node.base.Key;
import com.hedera.node.app.signature.SignatureVerificationFuture;
import com.hedera.node.app.signature.impl.SignatureVerificationImpl;
import com.hedera.node.app.spi.signatures.SignatureVerification;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class CompoundSignatureVerificationFuture
implements SignatureVerificationFuture {
    private final Key key;
    private final Bytes evmAlias;
    private final List<Future<SignatureVerification>> futures;
    private boolean canceled = false;
    private final int numCanFail;

    CompoundSignatureVerificationFuture(@NonNull Key key, @Nullable Bytes evmAlias, @NonNull List<Future<SignatureVerification>> futures, int numCanFail) {
        this.key = Objects.requireNonNull(key);
        this.evmAlias = evmAlias;
        this.futures = Objects.requireNonNull(futures);
        this.numCanFail = Math.max(0, numCanFail);
        if (futures.isEmpty()) {
            throw new IllegalArgumentException("The sigs cannot be empty");
        }
    }

    @Override
    @Nullable
    public Bytes evmAlias() {
        return this.evmAlias;
    }

    @Override
    @NonNull
    public Key key() {
        return this.key;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        boolean wasAbleToCancelAll = true;
        for (Future<SignatureVerification> future : this.futures) {
            if (future.isDone() || future.cancel(mayInterruptIfRunning)) continue;
            wasAbleToCancelAll = false;
        }
        this.canceled = true;
        return wasAbleToCancelAll;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        if (this.canceled) {
            return true;
        }
        for (Future<SignatureVerification> future : this.futures) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public SignatureVerification get() throws InterruptedException, ExecutionException {
        int failCount = 0;
        for (Future<SignatureVerification> future : this.futures) {
            SignatureVerification verification = future.get();
            if (verification.passed() || failCount++ < this.numCanFail) continue;
            return new SignatureVerificationImpl(this.key, this.evmAlias, false);
        }
        return new SignatureVerificationImpl(this.key, this.evmAlias, true);
    }

    @Override
    public SignatureVerification get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        int failCount = 0;
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        for (Future<SignatureVerification> future : this.futures) {
            long now;
            SignatureVerification verification = future.get(deadline - (now = System.currentTimeMillis()), TimeUnit.MILLISECONDS);
            if (!verification.failed() || failCount++ < this.numCanFail) continue;
            return new SignatureVerificationImpl(this.key, this.evmAlias, false);
        }
        return new SignatureVerificationImpl(this.key, this.evmAlias, true);
    }
}

