/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.stack;

import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.hedera.node.app.workflows.handle.stack.WritableKVStateStack;
import com.hedera.node.app.workflows.handle.stack.WritableQueueStateStack;
import com.hedera.node.app.workflows.handle.stack.WritableSingletonStateStack;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;

public class WritableStatesStack
implements WritableStates {
    private final SavepointStackImpl stack;
    private final String statesName;

    public WritableStatesStack(@NonNull SavepointStackImpl stack, @NonNull String serviceName) {
        this.stack = Objects.requireNonNull(stack, "stack must not be null");
        this.statesName = Objects.requireNonNull(serviceName, "serviceName must not be null");
    }

    @NonNull
    WritableStates getCurrent() {
        return this.stack.peek().state().getWritableStates(this.statesName);
    }

    @NonNull
    ReadableStates getRoot() {
        return this.stack.rootStates(this.statesName);
    }

    @NonNull
    public <K, V> WritableKVState<K, V> get(int stateId) {
        return new WritableKVStateStack(this, stateId);
    }

    @NonNull
    public <T> WritableSingletonState<T> getSingleton(int stateId) {
        return new WritableSingletonStateStack(this, stateId);
    }

    @NonNull
    public <E> WritableQueueState<E> getQueue(int stateId) {
        return new WritableQueueStateStack(this, stateId);
    }

    public boolean contains(int stateId) {
        return this.getCurrent().contains(stateId);
    }

    @NonNull
    public Set<Integer> stateIds() {
        return this.getCurrent().stateIds();
    }
}

