/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.prehandle;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.signature.ExpandedSignaturePair;
import com.hedera.node.app.signature.SignatureExpander;
import com.hedera.node.app.signature.SignatureVerificationFuture;
import com.hedera.node.app.signature.SignatureVerifier;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.store.ReadableStoreFactory;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.state.DeduplicationCache;
import com.hedera.node.app.workflows.InnerTransaction;
import com.hedera.node.app.workflows.TransactionChecker;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.hedera.node.app.workflows.prehandle.DueDiligenceException;
import com.hedera.node.app.workflows.prehandle.PreHandleContextImpl;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import com.hedera.node.app.workflows.prehandle.PreHandleWorkflow;
import com.hedera.node.app.workflows.purechecks.PureChecksContextImpl;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.transaction.Transaction;

@Singleton
public class PreHandleWorkflowImpl
implements PreHandleWorkflow {
    private static final Logger logger = LogManager.getLogger(PreHandleWorkflowImpl.class);
    private final TransactionChecker transactionChecker;
    private final TransactionDispatcher dispatcher;
    private final SignatureExpander signatureExpander;
    private final SignatureVerifier signatureVerifier;
    private final ConfigProvider configProvider;
    private final DeduplicationCache deduplicationCache;

    @Inject
    public PreHandleWorkflowImpl(@NonNull TransactionDispatcher dispatcher, @NonNull TransactionChecker transactionChecker, @NonNull SignatureVerifier signatureVerifier, @NonNull SignatureExpander signatureExpander, @NonNull ConfigProvider configProvider, @NonNull DeduplicationCache deduplicationCache) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.transactionChecker = Objects.requireNonNull(transactionChecker);
        this.signatureVerifier = Objects.requireNonNull(signatureVerifier);
        this.signatureExpander = Objects.requireNonNull(signatureExpander);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.deduplicationCache = Objects.requireNonNull(deduplicationCache);
    }

    @Override
    public void preHandle(@NonNull ReadableStoreFactory readableStoreFactory, @Nullable NodeInfo creatorInfo, @NonNull Stream<Transaction> transactions, @NonNull PreHandleWorkflow.ShortCircuitCallback shortCircuitCallback) {
        Objects.requireNonNull(readableStoreFactory);
        Objects.requireNonNull(transactions);
        Objects.requireNonNull(shortCircuitCallback);
        ReadableAccountStore accountStore = (ReadableAccountStore)readableStoreFactory.readableStore(ReadableAccountStore.class);
        ((Stream)transactions.parallel()).forEach(tx -> {
            try {
                PreHandleResult result = this.preHandleAllTransactions(creatorInfo, readableStoreFactory, accountStore, tx.getApplicationTransaction(), null, shortCircuitCallback);
                tx.setMetadata((Object)result);
            }
            catch (Exception e) {
                logger.error("Unexpected exception while running the pre-handle workflow", (Throwable)e);
                tx.setMetadata((Object)PreHandleResult.unknownFailure());
            }
        });
    }

    @Override
    @NonNull
    public PreHandleResult preHandleTransaction(@Nullable NodeInfo creatorInfo, @NonNull ReadableStoreFactory storeFactory, @NonNull ReadableAccountStore accountStore, @NonNull Bytes serializedSignedTx, @Nullable PreHandleResult previousResult, @NonNull PreHandleWorkflow.ShortCircuitCallback shortCircuitCallback, @NonNull InnerTransaction innerTransaction) {
        AccountID payer;
        Account payerAccount;
        TransactionInfo txInfo;
        if (!this.wasComputedWithCurrentNodeConfiguration(previousResult)) {
            previousResult = null;
        }
        try {
            boolean isStateSig;
            int maxBytes = ((HederaConfig)this.configProvider.getConfiguration().getConfigData(HederaConfig.class)).nodeTransactionMaxBytes();
            txInfo = previousResult == null ? this.transactionChecker.parseSignedAndCheck(serializedSignedTx, maxBytes) : previousResult.txInfo();
            if (txInfo == null) {
                return previousResult;
            }
            boolean bl = isStateSig = txInfo.functionality() == HederaFunctionality.STATE_SIGNATURE_TRANSACTION;
            if (creatorInfo == null || isStateSig) {
                Bytes bytes = txInfo.serializedSignedTxOrThrow();
                if (isStateSig) {
                    shortCircuitCallback.onShortCircuit(txInfo.txBody().stateSignatureTransaction(), bytes);
                } else {
                    shortCircuitCallback.onShortCircuit(null, bytes);
                }
                return PreHandleResult.shortCircuitingTransaction(txInfo);
            }
            if (innerTransaction == InnerTransaction.NO && !creatorInfo.accountId().equals((Object)txInfo.txBody().nodeAccountID())) {
                throw new DueDiligenceException(ResponseCodeEnum.INVALID_NODE_ACCOUNT, txInfo);
            }
        }
        catch (DueDiligenceException e) {
            return PreHandleResult.nodeDueDiligenceFailure(creatorInfo.accountId(), e.responseCode(), e.txInfo(), this.configProvider.getConfiguration().getVersion());
        }
        catch (PreCheckException e) {
            return PreHandleResult.nodeDueDiligenceFailure(creatorInfo.accountId(), e.responseCode(), null, this.configProvider.getConfiguration().getVersion());
        }
        try {
            this.transactionChecker.checkParsed(txInfo);
            this.transactionChecker.checkTransactionSize(txInfo);
        }
        catch (PreCheckException e) {
            return PreHandleResult.nodeDueDiligenceFailure(creatorInfo.accountId(), e.responseCode(), txInfo, this.configProvider.getConfiguration().getVersion());
        }
        if (previousResult == null) {
            this.deduplicationCache.add(txInfo.transactionID());
        }
        if ((payerAccount = accountStore.getAccountById(payer = txInfo.payerID())) == null) {
            return PreHandleResult.nodeDueDiligenceFailure(creatorInfo.accountId(), ResponseCodeEnum.PAYER_ACCOUNT_NOT_FOUND, txInfo, this.configProvider.getConfiguration().getVersion());
        }
        if (payerAccount.deleted()) {
            return PreHandleResult.nodeDueDiligenceFailure(creatorInfo.accountId(), ResponseCodeEnum.PAYER_ACCOUNT_DELETED, txInfo, this.configProvider.getConfiguration().getVersion());
        }
        try {
            this.transactionChecker.checkTransactionSizeLimitBasedOnPayer(txInfo, payer);
        }
        catch (PreCheckException e) {
            return PreHandleResult.nodeDueDiligenceFailure(creatorInfo.accountId(), e.responseCode(), txInfo, this.configProvider.getConfiguration().getVersion());
        }
        return this.expandAndVerifySignatures(txInfo, payer, payerAccount, storeFactory, previousResult, innerTransaction, creatorInfo);
    }

    private PreHandleResult expandAndVerifySignatures(TransactionInfo txInfo, AccountID payer, Account payerAccount, ReadableStoreFactory storeFactory, @Nullable PreHandleResult previousResult, @NonNull InnerTransaction innerTransaction, @NonNull NodeInfo creatorInfo) {
        Key payerKey;
        PayerIsHollow payerIsHollow;
        PreHandleContextImpl context;
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        TransactionBody txBody = txInfo.txBody();
        try {
            context = new PreHandleContextImpl(storeFactory, txBody, (Configuration)configuration, this.dispatcher, this.transactionChecker, creatorInfo);
        }
        catch (PreCheckException preCheck) {
            throw new RuntimeException("Payer account disappeared between preHandle and preHandleContext creation!", preCheck);
        }
        PayerIsHollow payerIsHollow2 = payerIsHollow = HapiUtils.isHollow((Account)payerAccount) ? PayerIsHollow.YES : PayerIsHollow.NO;
        if (payerIsHollow == PayerIsHollow.NO) {
            payerKey = payerAccount.keyOrThrow();
        } else {
            payerKey = null;
            context.requireSignatureForHollowAccount(payerAccount);
        }
        try {
            if (innerTransaction == InnerTransaction.NO && txInfo.txBody().hasBatchKey()) {
                throw new PreCheckException(ResponseCodeEnum.BATCH_KEY_SET_ON_NON_INNER_TRANSACTION);
            }
            PureChecksContextImpl pureChecksContext = new PureChecksContextImpl(txBody, this.dispatcher);
            this.dispatcher.dispatchPureChecks(pureChecksContext);
            this.dispatcher.dispatchPreHandle(context);
        }
        catch (PreCheckException preCheck) {
            logger.debug("Transaction failed pre-check", (Throwable)preCheck);
            Map<Key, SignatureVerificationFuture> results = this.verifySignatures(txInfo, context, VerifyOnlyPayerKey.YES, payerIsHollow, previousResult);
            return PreHandleResult.preHandleFailure(payer, payerKey, preCheck.responseCode(), txInfo, Set.of(), Set.of(), Set.of(), results);
        }
        Map<Key, SignatureVerificationFuture> results = this.verifySignatures(txInfo, context, VerifyOnlyPayerKey.NO, payerIsHollow, previousResult);
        return new PreHandleResult(payer, payerKey, PreHandleResult.Status.SO_FAR_SO_GOOD, ResponseCodeEnum.OK, txInfo, context.requiredNonPayerKeys(), context.optionalNonPayerKeys(), context.requiredHollowAccounts(), results, PreHandleWorkflowImpl.isAtomicBatch(txInfo) ? new ArrayList<PreHandleResult>() : null, configuration.getVersion());
    }

    static boolean isAtomicBatch(TransactionInfo txInfo) {
        return txInfo.functionality().equals((Object)HederaFunctionality.ATOMIC_BATCH);
    }

    private Map<Key, SignatureVerificationFuture> verifySignatures(@NonNull TransactionInfo txInfo, @NonNull PreHandleContext context, @NonNull VerifyOnlyPayerKey onlyPayerKey, @NonNull PayerIsHollow payerIsHollow, @Nullable PreHandleResult previousResult) {
        if (previousResult != null && previousResult.hasReusableVerificationResultsFor(context)) {
            return previousResult.verificationResults();
        }
        List originals = txInfo.signatureMap().sigPair();
        LinkedHashSet<ExpandedSignaturePair> expanded = new LinkedHashSet<ExpandedSignaturePair>();
        this.signatureExpander.expand(originals, expanded);
        if (payerIsHollow == PayerIsHollow.NO) {
            this.signatureExpander.expand(context.payerKey(), (List<SignaturePair>)originals, expanded);
        }
        if (onlyPayerKey == VerifyOnlyPayerKey.NO) {
            this.signatureExpander.expand(context.requiredNonPayerKeys(), (List<SignaturePair>)originals, expanded);
            this.signatureExpander.expand(context.optionalNonPayerKeys(), (List<SignaturePair>)originals, expanded);
        }
        return this.signatureVerifier.verify(txInfo.signedBytes(), expanded);
    }

    private boolean wasComputedWithCurrentNodeConfiguration(@Nullable PreHandleResult previousResult) {
        return previousResult == null || previousResult.configVersion() == this.configProvider.getConfiguration().getVersion();
    }

    private static enum PayerIsHollow {
        YES,
        NO;

    }

    private static enum VerifyOnlyPayerKey {
        YES,
        NO;

    }
}

