/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.time;

import com.swirlds.base.time.Time;

public class IntegerEpochTime {
    private final Time time;

    public IntegerEpochTime(Time time) {
        this.time = time;
    }

    public int getMilliTime() {
        return (int)(this.time.currentTimeMillis() % Integer.MAX_VALUE);
    }

    public int getMicroTime() {
        return (int)(this.time.nanoTime() / 1000L % Integer.MAX_VALUE);
    }

    public int millisElapsed(int startTime) {
        return IntegerEpochTime.elapsed(startTime, this.getMilliTime());
    }

    public int microsElapsed(int startTime) {
        return IntegerEpochTime.elapsed(startTime, this.getMicroTime());
    }

    public static int elapsed(int startTime, int endTime) {
        if (endTime >= startTime) {
            return endTime - startTime;
        }
        return Integer.MAX_VALUE - startTime + endTime;
    }
}

