/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.contract.codec.ContractCreateTransactionBodyProtoCodec;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoCreateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.contract.impl.annotations.TransactionScope;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.gas.TinybarValues;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaOperations;
import com.hedera.node.app.service.contract.impl.exec.utils.PendingCreationMetadata;
import com.hedera.node.app.service.contract.impl.exec.utils.PendingCreationMetadataRef;
import com.hedera.node.app.service.contract.impl.records.ContractCreateStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractOperationStreamBuilder;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.contract.impl.state.WritableContractStateStore;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.SynthTxnUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.api.ContractChangeSummary;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.throttle.ThrottleAdviser;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.ResourceExhaustedException;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UncheckedParseException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

@TransactionScope
public class HandleHederaOperations
implements HederaOperations {
    public static final com.hedera.pbj.runtime.io.buffer.Bytes ZERO_ENTROPY = com.hedera.pbj.runtime.io.buffer.Bytes.fromHex((String)"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    private static final CryptoCreateTransactionBody.Builder CREATE_TXN_BODY_BUILDER = CryptoCreateTransactionBody.newBuilder().initialBalance(0L).maxAutomaticTokenAssociations(-1).autoRenewPeriod(Duration.newBuilder().seconds(7776000L)).key(KeyUtils.IMMUTABILITY_SENTINEL_KEY);
    private final TinybarValues tinybarValues;
    private final ContractsConfig contractsConfig;
    private final SystemContractGasCalculator gasCalculator;
    private final HederaConfig hederaConfig;
    private final HandleContext context;
    private final HederaFunctionality functionality;
    private final PendingCreationMetadataRef pendingCreationMetadataRef;
    private final AccountsConfig accountsConfig;
    private final EntityIdFactory entityIdFactory;
    private final List<GasChargingEvent> gasChargingEvents = new ArrayList<GasChargingEvent>(1);
    private final ContractMetrics contractMetrics;

    @Inject
    public HandleHederaOperations(@NonNull ContractsConfig contractsConfig, @NonNull HandleContext context, @NonNull TinybarValues tinybarValues, @NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaConfig hederaConfig, @NonNull HederaFunctionality functionality, @NonNull PendingCreationMetadataRef pendingCreationMetadataRef, @NonNull AccountsConfig accountsConfig, @NonNull EntityIdFactory entityIdFactory, @NonNull ContractMetrics contractMetrics) {
        this.contractsConfig = Objects.requireNonNull(contractsConfig);
        this.context = Objects.requireNonNull(context);
        this.tinybarValues = Objects.requireNonNull(tinybarValues);
        this.gasCalculator = Objects.requireNonNull(gasCalculator);
        this.hederaConfig = Objects.requireNonNull(hederaConfig);
        this.functionality = Objects.requireNonNull(functionality);
        this.pendingCreationMetadataRef = Objects.requireNonNull(pendingCreationMetadataRef);
        this.accountsConfig = Objects.requireNonNull(accountsConfig);
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
        this.contractMetrics = Objects.requireNonNull(contractMetrics);
    }

    @Override
    @NonNull
    public HandleHederaOperations begin() {
        this.context.savepointStack().createSavepoint();
        return this;
    }

    @Override
    public void commit() {
        this.context.savepointStack().commit();
    }

    @Override
    public void revert() {
        this.context.savepointStack().rollback();
    }

    @Override
    public ContractStateStore getStore() {
        return (ContractStateStore)this.context.storeFactory().writableStore(WritableContractStateStore.class);
    }

    @Override
    public long peekNextEntityNumber() {
        return this.context.entityNumGenerator().peekAtNewEntityNum();
    }

    @Override
    public long useNextEntityNumber() {
        return this.context.entityNumGenerator().newEntityNum();
    }

    @Override
    public long contractCreationLimit() {
        return this.contractsConfig.maxNumber();
    }

    @Override
    public long accountCreationLimit() {
        return this.accountsConfig.maxNumber();
    }

    @Override
    @NonNull
    public com.hedera.pbj.runtime.io.buffer.Bytes entropy() {
        com.hedera.pbj.runtime.io.buffer.Bytes entropy = this.context.blockRecordInfo().prngSeed();
        return entropy == null || entropy.equals((Object)com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY) ? ZERO_ENTROPY : entropy;
    }

    @Override
    public long lazyCreationCostInGas(@NonNull Address recipient) {
        AccountID payerId = this.context.payer();
        TransactionBody synthCreation = TransactionBody.newBuilder().cryptoCreateAccount(CREATE_TXN_BODY_BUILDER.alias(ConversionUtils.tuweniToPbjBytes((Bytes)recipient))).build();
        long createFee = this.gasCalculator.feeCalculatorPriceInTinyBars(synthCreation, payerId);
        return createFee * 1000L / this.gasCalculator.topLevelGasPriceInTinyBars();
    }

    @Override
    public long gasPriceInTinybars() {
        return this.tinybarValues.topLevelTinybarGasPrice();
    }

    @Override
    public long valueInTinybars(long tinycents) {
        return this.tinybarValues.asTinybars(tinycents);
    }

    @Override
    public void collectHtsFee(@NonNull AccountID payerId, long amount) {
        Objects.requireNonNull(payerId);
        this.context.tryToCharge(payerId, amount);
    }

    @Override
    public void collectGasFee(@NonNull AccountID payerId, long amount, boolean withNonceIncrement) {
        Objects.requireNonNull(payerId);
        this.context.tryToCharge(payerId, amount);
        this.gasChargingEvents.add(new GasChargingEvent(GasChargingAction.CHARGE, payerId, amount, withNonceIncrement));
    }

    @Override
    public void refundGasFee(@NonNull AccountID payerId, long amount) {
        Objects.requireNonNull(payerId);
        this.context.refundBestEffort(payerId, amount);
        this.gasChargingEvents.add(new GasChargingEvent(GasChargingAction.REFUND, payerId, amount, false));
    }

    @Override
    public void replayGasChargingIn(@NonNull FeeCharging.Context feeChargingContext) {
        Objects.requireNonNull(feeChargingContext);
        LinkedHashMap<AccountID, Long> netCharges = new LinkedHashMap<AccountID, Long>();
        for (GasChargingEvent event : this.gasChargingEvents) {
            if (event.action() == GasChargingAction.CHARGE) {
                netCharges.merge(event.accountId(), event.amount(), Long::sum);
                if (!event.withNonceIncrement()) continue;
                TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
                tokenServiceApi.incrementSenderNonce(event.accountId());
                continue;
            }
            netCharges.merge(event.accountId(), -event.amount(), Long::sum);
        }
        netCharges.forEach((payerId, amount) -> feeChargingContext.charge(payerId, new Fees(0L, amount.longValue(), 0L), null));
    }

    @Override
    public void chargeStorageRent(ContractID contractID, long amount, boolean itemizeStoragePayments) {
    }

    @Override
    public void updateStorageMetadata(ContractID contractID, @NonNull com.hedera.pbj.runtime.io.buffer.Bytes firstKey, int netChangeInSlotsUsed) {
        Objects.requireNonNull(firstKey);
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        tokenServiceApi.updateStorageMetadata(contractID, firstKey, netChangeInSlotsUsed);
    }

    @Override
    public void updateHookStorageSlots(@NonNull AccountID accountId, int netChangeInSlotsUsed) {
        Objects.requireNonNull(accountId);
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        tokenServiceApi.updateHookStorageSlots(accountId, netChangeInSlotsUsed, false);
    }

    @Override
    public void createContract(long number, long parentNumber, @Nullable com.hedera.pbj.runtime.io.buffer.Bytes evmAddress) {
        ReadableAccountStore accountStore = (ReadableAccountStore)this.context.storeFactory().readableStore(ReadableAccountStore.class);
        Account parent = accountStore.getAccountById(this.entityIdFactory.newAccountId(parentNumber));
        ContractCreateTransactionBody impliedContractCreation = SynthTxnUtils.synthContractCreationFromParent(this.entityIdFactory.newContractId(number), Objects.requireNonNull(parent));
        try {
            this.dispatchAndMarkCreation(this.entityIdFactory.newContractId(number), SynthTxnUtils.synthAccountCreationFromHapi(this.entityIdFactory.newContractId(number), evmAddress, impliedContractCreation), impliedContractCreation, parent.autoRenewAccountId(), evmAddress, ExternalizeInitcodeOnSuccess.YES);
        }
        catch (HandleException e) {
            throw new ResourceExhaustedException(e.getStatus());
        }
    }

    @Override
    public void createContract(long number, @NonNull ContractCreateTransactionBody body, @Nullable com.hedera.pbj.runtime.io.buffer.Bytes evmAddress) {
        Objects.requireNonNull(body);
        this.dispatchAndMarkCreation(this.entityIdFactory.newContractId(number), SynthTxnUtils.synthAccountCreationFromHapi(this.entityIdFactory.newContractId(number), evmAddress, body), this.functionality == HederaFunctionality.ETHEREUM_TRANSACTION ? ConversionUtils.selfManagedCustomizedCreation(body, this.entityIdFactory.newContractId(number)) : null, body.autoRenewAccountId(), evmAddress, body.hasInitcode() ? ExternalizeInitcodeOnSuccess.NO : ExternalizeInitcodeOnSuccess.YES);
    }

    @Override
    public void deleteAliasedContract(@NonNull com.hedera.pbj.runtime.io.buffer.Bytes evmAddress) {
        Objects.requireNonNull(evmAddress);
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        tokenServiceApi.deleteContract(this.entityIdFactory.newContractIdWithEvmAddress(evmAddress));
    }

    @Override
    public void deleteUnaliasedContract(long number) {
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        tokenServiceApi.deleteContract(this.entityIdFactory.newContractId(number));
    }

    @Override
    public List<Long> getModifiedAccountNumbers() {
        return Collections.emptyList();
    }

    @Override
    public ContractChangeSummary summarizeContractChanges() {
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        return tokenServiceApi.summarizeContractChanges();
    }

    @Override
    public long getOriginalSlotsUsed(ContractID contractID) {
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        return tokenServiceApi.originalKvUsageFor(contractID);
    }

    @Override
    public void externalizeHollowAccountMerge(@NonNull ContractID contractId, @NonNull com.hedera.pbj.runtime.io.buffer.Bytes evmAddress) {
        Objects.requireNonNull(contractId);
        Objects.requireNonNull(evmAddress);
        ContractCreateStreamBuilder recordBuilder = ((ContractCreateStreamBuilder)this.context.savepointStack().addRemovableChildRecordBuilder(ContractCreateStreamBuilder.class, HederaFunctionality.CONTRACT_CREATE)).createdContractID(contractId).createdEvmAddress(evmAddress).status(ResponseCodeEnum.SUCCESS).signedTx(StreamBuilder.signedTxWith((TransactionBody)TransactionBody.newBuilder().contractCreateInstance(SynthTxnUtils.synthContractCreationForExternalization(contractId)).build())).evmCreateTransactionResult(EvmTransactionResult.newBuilder().contractId(contractId).build()).contractCreateResult(ContractFunctionResult.newBuilder().contractID(contractId).evmAddress(evmAddress).build());
        PendingCreationMetadata pendingCreationMetadata = new PendingCreationMetadata(recordBuilder, true);
        this.pendingCreationMetadataRef.set(contractId, pendingCreationMetadata);
    }

    @Override
    public ContractID shardAndRealmValidated(@NonNull ContractID contractId) {
        return this.configValidated(contractId, this.hederaConfig);
    }

    private void dispatchAndMarkCreation(@NonNull ContractID contractID, @NonNull CryptoCreateTransactionBody bodyToDispatch, @Nullable ContractCreateTransactionBody bodyToExternalize, @Nullable AccountID autoRenewAccountId, @Nullable com.hedera.pbj.runtime.io.buffer.Bytes evmAddress, @NonNull ExternalizeInitcodeOnSuccess externalizeInitcodeOnSuccess) {
        boolean isTopLevelCreation = bodyToExternalize == null;
        TransactionBody body = TransactionBody.newBuilder().cryptoCreateAccount(bodyToDispatch).build();
        StreamBuilder.SignedTxCustomizer transactionCustomizer = isTopLevelCreation ? StreamBuilder.SignedTxCustomizer.SUPPRESSING_SIGNED_TX_CUSTOMIZER : this.contractBodyCustomizerFor(contractID, bodyToExternalize);
        ContractCreateStreamBuilder streamBuilder = (ContractCreateStreamBuilder)this.context.dispatch(DispatchOptions.stepDispatch((AccountID)this.context.payer(), (TransactionBody)body, ContractCreateStreamBuilder.class, (StreamBuilder.SignedTxCustomizer)transactionCustomizer));
        if (streamBuilder.status() != ResponseCodeEnum.SUCCESS) {
            throw new IllegalStateException("Unexpected failure creating new contract - " + String.valueOf(streamBuilder.status()));
        }
        streamBuilder.functionality(HederaFunctionality.CONTRACT_CREATE);
        PendingCreationMetadata pendingCreationMetadata = new PendingCreationMetadata(isTopLevelCreation ? (ContractOperationStreamBuilder)this.context.savepointStack().getBaseBuilder(ContractOperationStreamBuilder.class) : streamBuilder, externalizeInitcodeOnSuccess == ExternalizeInitcodeOnSuccess.YES);
        ContractID newContractId = contractID.copyBuilder().build();
        this.pendingCreationMetadataRef.set(newContractId, pendingCreationMetadata);
        streamBuilder.createdContractID(newContractId).createdEvmAddress(evmAddress).evmCreateTransactionResult(EvmTransactionResult.newBuilder().contractId(newContractId).build()).contractCreateResult(ContractFunctionResult.newBuilder().contractID(newContractId).evmAddress(evmAddress).build());
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        AccountID accountId = AccountID.newBuilder().shardNum(contractID.shardNum()).realmNum(contractID.realmNum()).accountNum(contractID.contractNumOrThrow().longValue()).build();
        tokenServiceApi.markAsContract(accountId, autoRenewAccountId);
    }

    private StreamBuilder.SignedTxCustomizer contractBodyCustomizerFor(@NonNull ContractID contractID, @NonNull ContractCreateTransactionBody op) {
        return signedTx -> {
            try {
                TransactionBody dispatchedBody = (TransactionBody)TransactionBody.PROTOBUF.parseStrict(signedTx.bodyBytes().toReadableSequentialData());
                if (!dispatchedBody.hasCryptoCreateAccount()) {
                    throw new IllegalArgumentException("Dispatched transaction body was not a crypto create" + String.valueOf(dispatchedBody));
                }
                ContractCreateTransactionBody standardizedOp = this.standardized(contractID, op);
                return StreamBuilder.signedTxWith((TransactionBody)dispatchedBody.copyBuilder().contractCreateInstance(standardizedOp).build());
            }
            catch (ParseException e) {
                throw new UncheckedParseException(e);
            }
        };
    }

    private ContractCreateTransactionBody standardized(@NonNull ContractID contractID, @NonNull ContractCreateTransactionBody op) {
        if (this.needsStandardization(op)) {
            Key newAdminKey = op.adminKey();
            if (!op.hasAdminKey()) {
                newAdminKey = Key.newBuilder().contractID(contractID.copyBuilder().build()).build();
            }
            return new ContractCreateTransactionBody(ContractCreateTransactionBodyProtoCodec.INITCODE_SOURCE_UNSET, newAdminKey, 0L, 0L, op.proxyAccountID(), op.autoRenewPeriod(), op.constructorParameters(), op.shardID(), op.realmID(), op.newRealmAdminKey(), op.memo(), op.maxAutomaticTokenAssociations(), op.autoRenewAccountId(), op.stakedId(), op.declineReward(), List.of());
        }
        return op;
    }

    private boolean needsStandardization(@NonNull ContractCreateTransactionBody op) {
        return op.hasInitcode() || op.gas() > 0L || op.initialBalance() > 0L;
    }

    @Override
    @Nullable
    public ThrottleAdviser getThrottleAdviser() {
        return this.context.throttleAdviser();
    }

    @Override
    public ContractMetrics contractMetrics() {
        return this.contractMetrics;
    }

    private record GasChargingEvent(GasChargingAction action, AccountID accountId, long amount, boolean withNonceIncrement) {
    }

    private static enum GasChargingAction {
        CHARGE,
        REFUND;

    }

    private static enum ExternalizeInitcodeOnSuccess {
        YES,
        NO;

    }
}

