/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.pauses;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.token.TokenPauseTransactionBody;
import com.hedera.hapi.node.token.TokenUnpauseTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.pauses.PausesTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PausesDecoder {
    @Inject
    public PausesDecoder() {
    }

    public TransactionBody decodePause(@NonNull HtsCallAttempt attempt) {
        Tuple call = PausesTranslator.PAUSE.decodeCall(attempt.inputBytes());
        return TransactionBody.newBuilder().tokenPause(this.pause(attempt, (Address)call.get(0))).build();
    }

    private TokenPauseTransactionBody pause(@NonNull HtsCallAttempt attempt, @NonNull Address tokenAddress) {
        return TokenPauseTransactionBody.newBuilder().token(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), tokenAddress)).build();
    }

    public TransactionBody decodeUnpause(@NonNull HtsCallAttempt attempt) {
        Tuple call = PausesTranslator.UNPAUSE.decodeCall(attempt.inputBytes());
        return TransactionBody.newBuilder().tokenUnpause(this.unpause(attempt, (Address)call.get(0))).build();
    }

    private TokenUnpauseTransactionBody unpause(@NonNull HtsCallAttempt attempt, @NonNull Address tokenAddress) {
        return TokenUnpauseTransactionBody.newBuilder().token(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), tokenAddress)).build();
    }
}

