/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.tokenuri;

import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.tokenuri.TokenUriCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenUriTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod TOKEN_URI = SystemContractMethod.declare("tokenURI(uint256)", "(string)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ERC721, SystemContractMethod.Category.TOKEN_QUERY);

    @Inject
    public TokenUriTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(TOKEN_URI);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(TOKEN_URI);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        long serialNo = ConversionUtils.asExactLongValueOrZero((BigInteger)TOKEN_URI.decodeCall(attempt.input().toArrayUnsafe()).get(0));
        return new TokenUriCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.redirectToken(), serialNo);
    }
}

