/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2Frame;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Setting;
import io.helidon.http.http2.Http2Settings;
import java.nio.charset.StandardCharsets;

public record Http2GoAway(int lastStreamId, Http2ErrorCode errorCode, String details) implements Http2Frame<Http2Flag.NoFlags>
{
    public static Http2GoAway create(BufferData frame) {
        int lastStreamId = BufferData.toInt31((int)frame.readInt32());
        int errorCode = frame.readInt32();
        Http2ErrorCode code = Http2ErrorCode.get(errorCode);
        String details = frame.debugDataHex(false);
        return new Http2GoAway(lastStreamId, code, details);
    }

    @Override
    public Http2FrameData toFrameData(Http2Settings settings, int streamId, Http2Flag.NoFlags flags) {
        byte[] detailBytes = this.details == null ? BufferData.EMPTY_BYTES : this.details.getBytes(StandardCharsets.UTF_8);
        long len = Math.min((long)detailBytes.length, settings.value(Http2Setting.MAX_FRAME_SIZE) - 8L);
        BufferData data = BufferData.create((int)(8 + (int)len));
        int toWriteLastStream = this.lastStreamId & Integer.MAX_VALUE;
        if (toWriteLastStream != this.lastStreamId) {
            throw new Http2Exception(Http2ErrorCode.INTERNAL, "Attempt to use 32bit integer for stream id, only 31 bits are allowed");
        }
        data.writeInt32(toWriteLastStream);
        data.writeInt32(this.errorCode.code());
        data.write(detailBytes, 0, (int)len);
        Http2FrameHeader header = Http2FrameHeader.create(data.available(), this.frameTypes(), flags, streamId);
        return new Http2FrameData(header, data);
    }

    @Override
    public String name() {
        return Http2FrameType.GO_AWAY.name();
    }

    @Override
    public Http2FrameType frameType() {
        return Http2FrameType.GO_AWAY;
    }

    @Override
    public Http2FrameTypes<Http2Flag.NoFlags> frameTypes() {
        return Http2FrameTypes.GO_AWAY;
    }
}

