/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.platform;

import com.swirlds.base.utility.Pair;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.snapshot.Snapshot;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.ThresholdLimitingHandler;
import org.hiero.consensus.concurrent.config.BasicCommonConfig;
import org.hiero.consensus.metrics.config.MetricsConfig;
import org.hiero.consensus.metrics.platform.SnapshotEvent;
import org.hiero.consensus.model.node.NodeId;

public class LegacyCsvWriter {
    private static final Logger logger = LogManager.getLogger(LegacyCsvWriter.class);
    private static final String EXCLUDE_CATEGORY = "info";
    private final NodeId selfId;
    private final Path csvFilePath;
    private final MetricsConfig metricsConfig;
    private final BasicCommonConfig basicConfig;
    private final Map<Pair<String, String>, Integer> indexLookup = new HashMap<Pair<String, String>, Integer>();
    private final List<Integer> cellCount = new ArrayList<Integer>();
    private final ThresholdLimitingHandler<String> warningRateLimiter = new ThresholdLimitingHandler(1L, Function.identity());
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final AtomicBoolean inconsistent = new AtomicBoolean();

    public LegacyCsvWriter(@NonNull NodeId selfId, @NonNull Path folderPath, @NonNull Configuration configuration) {
        Objects.requireNonNull(folderPath, "folderPath is null");
        Objects.requireNonNull(configuration, "configuration is null");
        this.selfId = Objects.requireNonNull(selfId, "selfId is null");
        this.metricsConfig = (MetricsConfig)configuration.getConfigData(MetricsConfig.class);
        this.basicConfig = (BasicCommonConfig)configuration.getConfigData(BasicCommonConfig.class);
        String fileName = String.format("%s%d.csv", this.metricsConfig.csvFileName(), selfId.id());
        this.csvFilePath = folderPath.resolve(fileName);
    }

    public Path getCsvFilePath() {
        return this.csvFilePath;
    }

    private void init(Collection<Snapshot> snapshots) {
        logger.info(LogMarker.STARTUP.getMarker(), "CsvWriter: Initializing statistics output in CSV format [ csvOutputFolder = '{}', csvFileName = '{}' ]", (Object)this.csvFilePath.getParent(), (Object)this.csvFilePath.getFileName());
        List<Metric> filteredMetrics = snapshots.stream().map(Snapshot::metric).filter(this::shouldWrite).toList();
        this.indexLookup.clear();
        this.cellCount.clear();
        int index = 0;
        for (Metric metric : filteredMetrics) {
            this.indexLookup.put((Pair<String, String>)Pair.of((Object)metric.getCategory(), (Object)metric.getName()), index++);
            this.cellCount.add(this.showAllEntries(metric) ? metric.getValueTypes().size() : 1);
        }
        try {
            this.ensureFolderExists();
            if (this.metricsConfig.csvAppend() && Files.exists(this.csvFilePath, new LinkOption[0])) {
                Files.writeString(this.csvFilePath, (CharSequence)"\n\n", StandardOpenOption.APPEND);
            } else {
                ContentBuilder builder = new ContentBuilder();
                builder.addCell("filename:").addCell(this.csvFilePath).newRow();
                for (Metric metric : filteredMetrics) {
                    builder.addCell(metric.getName() + ":").addCell(metric.getDescription()).newRow();
                }
                builder.newRow();
                this.addHeaderRows(builder, filteredMetrics);
                Files.writeString(this.csvFilePath, (CharSequence)builder.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private boolean showAllEntries(@NonNull Metric metric) {
        Objects.requireNonNull(metric, "metric is null");
        return this.basicConfig.verboseStatistics() && !metric.getCategory().contains(EXCLUDE_CATEGORY);
    }

    private void addHeaderRows(@NonNull ContentBuilder builder, @NonNull List<Metric> metrics) {
        Objects.requireNonNull(builder, "builder is null");
        Objects.requireNonNull(metrics, "metrics is null");
        ArrayList<String> categories = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (Metric metric : metrics) {
            if (this.showAllEntries(metric)) {
                LegacyCsvWriter.addAllSupportedTypes(categories, names, metric);
                continue;
            }
            categories.add(metric.getCategory());
            names.add(metric.getName());
        }
        builder.addCell("").addCell("").addCells(categories).newRow();
        builder.addCell("").addCell("").addCells(names).newRow();
    }

    private static void addAllSupportedTypes(List<String> categories, List<String> names, Metric metric) {
        block5: for (Metric.ValueType metricType : metric.getValueTypes()) {
            categories.add(metric.getCategory());
            switch (metricType) {
                case MAX: {
                    names.add(metric.getName() + "Max");
                    continue block5;
                }
                case MIN: {
                    names.add(metric.getName() + "Min");
                    continue block5;
                }
                case STD_DEV: {
                    names.add(metric.getName() + "Std");
                    continue block5;
                }
            }
            names.add(metric.getName());
        }
    }

    public void handleSnapshots(SnapshotEvent snapshotEvent) {
        if (snapshotEvent.nodeId() != this.selfId) {
            return;
        }
        Collection<Snapshot> snapshots = snapshotEvent.snapshots();
        if (this.initialized.compareAndSet(false, true)) {
            this.init(snapshots);
        }
        Snapshot[] sortedSnapshots = new Snapshot[this.indexLookup.size()];
        boolean changedAfterInit = this.indexLookup.size() != snapshots.size();
        for (Snapshot snapshot : snapshots) {
            Metric metric = snapshot.metric();
            Integer index = this.indexLookup.get(Pair.of((Object)metric.getCategory(), (Object)metric.getName()));
            if (index != null) {
                sortedSnapshots[index.intValue()] = snapshot;
                continue;
            }
            changedAfterInit = true;
        }
        if (changedAfterInit && this.inconsistent.compareAndSet(false, changedAfterInit)) {
            this.reportInconsistentState(snapshots);
        }
        ContentBuilder builder = new ContentBuilder();
        builder.addCell("").addCell("");
        int n = sortedSnapshots.length;
        for (int i = 0; i < n; ++i) {
            Snapshot snapshot = sortedSnapshots[i];
            if (snapshot != null) {
                this.addSnapshotData(builder, snapshot);
                continue;
            }
            builder.addEmptyCells(this.cellCount.get(i));
        }
        builder.newRow();
        try {
            Files.writeString(this.csvFilePath, (CharSequence)builder.toString(), StandardOpenOption.APPEND);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void reportInconsistentState(Collection<Snapshot> snapshots) {
        logger.warn(LogMarker.METRICS.getMarker(), "Some metrics were not exported due to changes after LegacyCsvWriter initialization.");
        if (logger.isTraceEnabled()) {
            String willNotBeExported = snapshots.stream().map(Snapshot::metric).map(m -> Pair.of((Object)m.getCategory(), (Object)m.getName())).filter(p -> !this.indexLookup.containsKey(p)).map(p -> "[" + (String)p.key() + "-" + (String)p.right() + "]").collect(Collectors.joining(","));
            logger.trace("The following metrics will not be exported because they were not part of the initialization:{}", (Object)willNotBeExported);
        }
    }

    private void addSnapshotData(ContentBuilder builder, Snapshot snapshot) {
        if (this.showAllEntries(snapshot.metric())) {
            snapshot.entries().forEach(entry -> builder.addCell(this.format(snapshot.metric(), entry.value())));
        } else {
            List entries = snapshot.entries();
            Object value = entries.size() == 1 ? ((Snapshot.SnapshotEntry)entries.get(0)).value() : entries.stream().filter(entry -> entry.valueType() == Metric.ValueType.VALUE).findAny().map(Snapshot.SnapshotEntry::value).orElse(null);
            builder.addCell(this.format(snapshot.metric(), value));
        }
    }

    private String format(Metric metric, Object value) {
        Number number;
        String identifier = metric.getIdentifier();
        if (value instanceof Number && (Double.isNaN((number = (Number)value).doubleValue()) || Double.isInfinite(number.doubleValue()))) {
            this.warningRateLimiter.handle((Object)identifier, id -> logger.warn(LogMarker.EXCEPTION.getMarker(), "Metric '{}' has illegal value: {}", id, value));
            return String.format(Locale.US, metric.getFormat(), 0.0);
        }
        try {
            String result = String.format(Locale.US, metric.getFormat(), value);
            this.warningRateLimiter.reset((Object)identifier);
            return result;
        }
        catch (IllegalFormatException e) {
            this.warningRateLimiter.handle((Object)identifier, id -> logger.error(LogMarker.EXCEPTION.getMarker(), "Metric '{}' has wrong format: {}", id, value));
            return "";
        }
    }

    private boolean shouldWrite(@NonNull Metric metric) {
        Objects.requireNonNull(metric, "metric is null");
        return this.basicConfig.showInternalStats() || !metric.getCategory().equals("internal");
    }

    private void ensureFolderExists() throws IOException {
        Path parentFolder = this.csvFilePath.getParent();
        if (!Files.exists(parentFolder, new LinkOption[0])) {
            logger.debug(LogMarker.STARTUP.getMarker(), "CsvWriter: Creating the metrics folder [ folder = '{}' ]", (Object)parentFolder);
            Files.createDirectories(parentFolder, new FileAttribute[0]);
        } else {
            logger.debug(LogMarker.STARTUP.getMarker(), "CsvWriter: Using the existing metrics folder [ folder = '{}' ]", (Object)parentFolder);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("csvFilePath", (Object)this.csvFilePath).toString();
    }

    private static class ContentBuilder {
        private final StringBuilder builder = new StringBuilder();

        private ContentBuilder() {
        }

        private ContentBuilder addCells(List<?> cells) {
            for (Object cell : cells) {
                this.addCell(cell);
            }
            return this;
        }

        private ContentBuilder addCell(Object cell) {
            this.builder.append(Objects.toString(cell).trim().replace(",", "")).append(',');
            return this;
        }

        private void addEmptyCells(int count) {
            this.builder.append(",".repeat(count));
        }

        private void newRow() {
            this.builder.append('\n');
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

