/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.vm;

import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.binary.QueueState;
import com.swirlds.state.merkle.vm.VirtualMapQueueHelper;
import com.swirlds.state.spi.ReadableQueueStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Objects;

public class VirtualMapReadableQueueState<V>
extends ReadableQueueStateBase<V> {
    @NonNull
    private final VirtualMapQueueHelper<V> virtualMapQueueHelper;

    public VirtualMapReadableQueueState(int stateId, @NonNull String label, @NonNull Codec<V> valueCodec, @NonNull VirtualMap virtualMap) {
        super(stateId, label);
        this.virtualMapQueueHelper = new VirtualMapQueueHelper<V>(stateId, valueCodec, virtualMap);
    }

    @Nullable
    protected V peekOnDataSource() {
        QueueState state = this.virtualMapQueueHelper.getState();
        Objects.requireNonNull(state);
        return VirtualMapQueueHelper.isEmpty(state) ? null : (V)this.virtualMapQueueHelper.getFromStore(state.head());
    }

    @NonNull
    protected Iterator<V> iterateOnDataSource() {
        QueueState state = this.virtualMapQueueHelper.getState();
        if (state == null) {
            return this.virtualMapQueueHelper.iterateOnDataSource(0L, 0L);
        }
        return this.virtualMapQueueHelper.iterateOnDataSource(state.head(), state.tail());
    }
}

