/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.types;

import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ScaleFactor;
import com.hedera.node.config.types.UtilizationScaleFactors;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record EntityScaleFactors(UtilizationScaleFactors defaultScaleFactors, Map<EntityType, UtilizationScaleFactors> typeScaleFactors) {
    private static final Logger log = LogManager.getLogger(EntityScaleFactors.class);
    private static final String DEFAULT_TYPE = "DEFAULT";
    private static final Pattern SCOPED_FACTOR_PATTERN = Pattern.compile("(.*?)\\((.*?)\\),?");
    private static final UtilizationScaleFactors NOOP_SCALE_FACTORS = new UtilizationScaleFactors(new int[]{0}, new ScaleFactor[]{ScaleFactor.ONE_TO_ONE});

    public static EntityScaleFactors from(String csv) {
        try {
            return EntityScaleFactors.parseScaleFactorsByEntity(csv);
        }
        catch (Exception any) {
            log.warn("Unable to parse '{}' as an entity scale factors spec, using 1:1 everywhere", (Object)csv, (Object)any);
            return new EntityScaleFactors(NOOP_SCALE_FACTORS, new EnumMap<EntityType, UtilizationScaleFactors>(EntityType.class));
        }
    }

    private static EntityScaleFactors parseScaleFactorsByEntity(String csv) {
        UtilizationScaleFactors defaultScaleFactors = NOOP_SCALE_FACTORS;
        EnumMap<EntityType, UtilizationScaleFactors> typeScaleFactors = new EnumMap<EntityType, UtilizationScaleFactors>(EntityType.class);
        Matcher matcher = SCOPED_FACTOR_PATTERN.matcher(csv);
        while (matcher.find()) {
            String entityType = matcher.group(1);
            UtilizationScaleFactors scaleFactors = UtilizationScaleFactors.from(matcher.group(2));
            if (DEFAULT_TYPE.equals(entityType)) {
                defaultScaleFactors = scaleFactors;
                continue;
            }
            typeScaleFactors.put(EntityType.valueOf((String)entityType), scaleFactors);
        }
        return new EntityScaleFactors(defaultScaleFactors, typeScaleFactors);
    }

    public ScaleFactor scaleForNew(EntityType type, int utilPercent) {
        ScaleFactor choice = ScaleFactor.ONE_TO_ONE;
        UtilizationScaleFactors choicesForEntity = this.typeScaleFactors.getOrDefault(type, this.defaultScaleFactors);
        int[] triggers = choicesForEntity.usagePercentTriggers();
        for (int i = 0; i < triggers.length && utilPercent >= triggers[i]; ++i) {
            choice = choicesForEntity.scaleFactors()[i];
        }
        return choice;
    }
}

