/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.consensus.ConsensusCreateTopicTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.hapi.fees.FeeKeyUtils;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class ConsensusCreateTopicFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeecontext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        boolean hasCustomFees;
        long keys = 0L;
        ConsensusCreateTopicTransactionBody op = txnBody.consensusCreateTopicOrThrow();
        if (op.hasAdminKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.adminKey());
        }
        if (op.hasFeeScheduleKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.feeScheduleKey());
        }
        if (op.hasSubmitKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.submitKey());
        }
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CONSENSUS_CREATE_TOPIC);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        this.addExtraFee(feeResult, serviceDef, Extra.KEYS, feeSchedule, keys);
        boolean bl = hasCustomFees = !op.customFees().isEmpty();
        if (hasCustomFees) {
            this.addExtraFee(feeResult, serviceDef, Extra.CONSENSUS_CREATE_TOPIC_WITH_CUSTOM_FEE, feeSchedule, 1L);
        }
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CONSENSUS_CREATE_TOPIC;
    }
}

