/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli;

import com.swirlds.base.formatting.TextEffect;
import com.swirlds.common.startup.Log4jSetup;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.hiero.consensus.pcli.AbstractCommand;
import org.hiero.consensus.pcli.utility.CommandBuilder;
import org.hiero.consensus.pcli.utility.PlatformCliLogo;
import picocli.CommandLine;

@CommandLine.Command(name="pcli", version={"0.40.0"}, mixinStandardHelpOptions=true, description={"Miscellaneous platform utilities."})
public class Pcli
extends AbstractCommand {
    @CommandLine.Option(names={"-B", "--banner"}, description={"Show the ASCII banner on startup"})
    private boolean showBanner = false;
    @CommandLine.Option(names={"--no-color"}, description={"Disable colored output"})
    private boolean noColor = false;
    @CommandLine.Option(names={"--log4j"}, description={"Path to log4j configuration file"})
    private Path log4jPath;
    @CommandLine.Option(names={"-C", "--cli"}, description={"Package prefix where CLI commands/subcommands can be found. Commands annotated with '@SubcommandOf' in these packages are automatically integrated into pcli."})
    private List<String> cliPackagePrefixes;

    public static void main(String[] args) {
        CommandBuilder.whitelistCliPackage("org.hiero.consensus.pcli");
        CommandBuilder.whitelistCliPackage("com.swirlds.platform.state.editor");
        CommandLine commandLine = CommandBuilder.buildCommandLine(Pcli.class);
        commandLine.setExecutionStrategy((CommandLine.IExecutionStrategy)new SetupExecutionStrategy());
        System.exit(commandLine.execute(args));
    }

    static class SetupExecutionStrategy
    implements CommandLine.IExecutionStrategy {
        SetupExecutionStrategy() {
        }

        public int execute(CommandLine.ParseResult parseResult) {
            Pcli pcli = (Pcli)parseResult.commandSpec().commandLine().getCommand();
            TextEffect.setTextEffectsEnabled((!pcli.noColor ? 1 : 0) != 0);
            boolean showBannerFromScript = Boolean.parseBoolean(System.getProperty("pcli.showBanner", "false"));
            if (pcli.showBanner || showBannerFromScript) {
                System.out.println(PlatformCliLogo.getColorizedLogo());
            }
            CountDownLatch log4jLatch = Log4jSetup.startLoggingFramework((Path)pcli.log4jPath);
            if (pcli.cliPackagePrefixes != null) {
                pcli.cliPackagePrefixes.forEach(CommandBuilder::whitelistCliPackage);
            }
            try {
                log4jLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting for logging setup", e);
            }
            return new CommandLine.RunLast().execute(parseResult);
        }
    }
}

