/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import java.util.List;

public enum TokenSupplyType implements EnumWithProtoMetadata
{
    INFINITE(0, "INFINITE"),
    FINITE(1, "FINITE"),
    UNRECOGNIZED(-1, "UNRECOGNIZED");

    private final int protoOrdinal;
    private final String protoName;

    private TokenSupplyType(int protoOrdinal, String protoName) {
        this.protoOrdinal = protoOrdinal;
        this.protoName = protoName;
    }

    public int protoOrdinal() {
        return this.protoOrdinal;
    }

    public String protoName() {
        return this.protoName;
    }

    public static TokenSupplyType fromProtobufOrdinal(int ordinal) {
        return switch (ordinal) {
            case 0 -> INFINITE;
            case 1 -> FINITE;
            default -> UNRECOGNIZED;
        };
    }

    public static TokenSupplyType fromString(String name) {
        return switch (name) {
            case "INFINITE" -> INFINITE;
            case "FINITE" -> FINITE;
            default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
        };
    }

    public static TokenSupplyType fromObject(Object obj) {
        if (obj == null) {
            return TokenSupplyType.fromProtobufOrdinal(0);
        }
        if (obj instanceof TokenSupplyType) {
            TokenSupplyType pbjEnum = (TokenSupplyType)((Object)obj);
            return pbjEnum;
        }
        return UNRECOGNIZED;
    }

    public static List<TokenSupplyType> fromObjects(List<?> list) {
        return list.stream().map(TokenSupplyType::fromObject).toList();
    }

    public static int toProtoOrdinal(Object obj) {
        if (obj instanceof TokenSupplyType) {
            TokenSupplyType pbjEnum = (TokenSupplyType)((Object)obj);
            return pbjEnum.protoOrdinal();
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return i;
        }
        throw new IllegalArgumentException("Neither TokenSupplyType, nor Integer, but: " + obj.getClass().getName());
    }

    public static List<Integer> toProtoOrdinals(List<?> list) {
        return list.stream().map(TokenSupplyType::toProtoOrdinal).toList();
    }

    public static int compare(Object o1, Object o2) {
        int i2;
        int i1;
        if (o1 instanceof TokenSupplyType) {
            TokenSupplyType e1 = (TokenSupplyType)((Object)o1);
            if (o2 instanceof TokenSupplyType) {
                TokenSupplyType e2 = (TokenSupplyType)((Object)o2);
                return e1.compareTo(e2);
            }
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 instanceof TokenSupplyType) {
            TokenSupplyType e1 = (TokenSupplyType)((Object)o1);
            i1 = e1.protoOrdinal();
        } else if (o1 instanceof Integer) {
            Integer ii1 = (Integer)o1;
            i1 = ii1;
        } else {
            throw new IllegalArgumentException("o1 is neither TokenSupplyType, nor Integer. It's: " + o1.getClass().getName());
        }
        if (o2 instanceof TokenSupplyType) {
            TokenSupplyType e2 = (TokenSupplyType)((Object)o2);
            i2 = e2.protoOrdinal();
        } else if (o2 instanceof Integer) {
            Integer ii2 = (Integer)o2;
            i2 = ii2;
        } else {
            throw new IllegalArgumentException("o2 is neither TokenSupplyType, nor Integer. It's: " + o2.getClass().getName());
        }
        return Integer.compare(i1, i2);
    }
}

