/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.gossip.shadowgraph;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ShadowEvent;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public final class SyncUtils {
    private static final Logger logger = LogManager.getLogger();

    private SyncUtils() {
    }

    @NonNull
    public static List<PlatformEvent> filterLikelyDuplicates(@NonNull NodeId selfId, @NonNull Duration nonAncestorThreshold, @NonNull Duration ancestorFilterThreshold, @NonNull Duration selfFilterThreshold, @NonNull Instant now, @NonNull List<PlatformEvent> eventsTheyNeed) {
        LinkedList<PlatformEvent> filteredList = new LinkedList<PlatformEvent>();
        HashSet<Hash> parentHashesOfEventsToSend = new HashSet<Hash>();
        for (int index = eventsTheyNeed.size() - 1; index >= 0; --index) {
            boolean alwaysRecurse;
            Duration needsToBeAtLeastThatOld;
            PlatformEvent event = eventsTheyNeed.get(index);
            if (event.getCreatorId().equals((Object)selfId)) {
                needsToBeAtLeastThatOld = selfFilterThreshold;
                alwaysRecurse = true;
            } else if (parentHashesOfEventsToSend.contains(event.getHash())) {
                needsToBeAtLeastThatOld = ancestorFilterThreshold;
                alwaysRecurse = true;
            } else {
                needsToBeAtLeastThatOld = nonAncestorThreshold;
                alwaysRecurse = false;
            }
            boolean sendEvent = SyncUtils.haveWeKnownAboutEventForALongTime(event, needsToBeAtLeastThatOld, now);
            if (sendEvent) {
                filteredList.addFirst(event);
            }
            if (!sendEvent && !alwaysRecurse) continue;
            for (EventDescriptorWrapper otherParent : event.getAllParents()) {
                parentHashesOfEventsToSend.add(otherParent.hash());
            }
        }
        return filteredList.stream().toList();
    }

    private static boolean haveWeKnownAboutEventForALongTime(@NonNull PlatformEvent event, @NonNull Duration nonAncestorThreshold, @NonNull Instant now) {
        Instant eventReceivedTime = event.getTimeReceived();
        Duration timeKnown = Duration.between(eventReceivedTime, now);
        return CompareTo.isGreaterThan((Comparable)timeKnown, (Object)nonAncestorThreshold);
    }

    @NonNull
    public static Predicate<ShadowEvent> unknownNonAncient(@NonNull Collection<ShadowEvent> knownShadows, @NonNull EventWindow myEventWindow, @NonNull EventWindow theirEventWindow) {
        long minimumSearchThreshold = Math.max(myEventWindow.expiredThreshold(), theirEventWindow.ancientThreshold());
        return s -> s.getPlatformEvent().getBirthRound() >= minimumSearchThreshold && !knownShadows.contains(s);
    }

    public static int computeMultiTipCount(Iterable<ShadowEvent> tips) {
        HashMap<NodeId, Integer> tipCountByCreator = new HashMap<NodeId, Integer>();
        for (ShadowEvent tip : tips) {
            tipCountByCreator.compute(tip.getPlatformEvent().getCreatorId(), (k, v) -> v != null ? v + 1 : 1);
        }
        int creatorsWithBranches = 0;
        for (Map.Entry entry : tipCountByCreator.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            ++creatorsWithBranches;
        }
        return creatorsWithBranches;
    }

    static void sort(@NonNull List<PlatformEvent> sendList) {
        sendList.sort(Comparator.comparingLong(PlatformEvent::getNGen));
    }

    @NonNull
    static List<Boolean> getTheirTipsIHave(@NonNull List<ShadowEvent> theirTipShadows) {
        ArrayList<Boolean> myBooleans = new ArrayList<Boolean>(theirTipShadows.size());
        for (ShadowEvent s : theirTipShadows) {
            myBooleans.add(s != null);
        }
        return myBooleans;
    }

    @NonNull
    static List<ShadowEvent> getMyTipsTheyKnow(@NonNull NodeId peerId, @NonNull List<ShadowEvent> myTips, @NonNull List<Boolean> myTipsTheyHave) {
        Objects.requireNonNull(peerId);
        if (myTipsTheyHave.size() != myTips.size()) {
            throw new RuntimeException(String.format("during sync with %s, peer booleans list is wrong size. Expected: %d Actual: %d,", peerId, myTips.size(), myTipsTheyHave.size()));
        }
        return SyncUtils.getMyTipsTheyKnow(myTips, myTipsTheyHave);
    }

    @NonNull
    private static List<ShadowEvent> getMyTipsTheyKnow(@NonNull List<ShadowEvent> myTips, @NonNull List<Boolean> myTipsTheyHave) {
        ArrayList<ShadowEvent> knownTips = new ArrayList<ShadowEvent>();
        for (int i = 0; i < myTipsTheyHave.size(); ++i) {
            if (!Boolean.TRUE.equals(myTipsTheyHave.get(i))) continue;
            knownTips.add(myTips.get(i));
        }
        return knownTips;
    }
}

