/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.workflows;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class PreCheckException
extends Exception {
    private final ResponseCodeEnum responseCode;

    public PreCheckException(@NonNull ResponseCodeEnum responseCode) {
        super(responseCode.protoName());
        this.responseCode = Objects.requireNonNull(responseCode);
    }

    private PreCheckException(@NonNull ResponseCodeEnum responseCode, @Nullable Throwable cause) {
        throw new UnsupportedOperationException("PreCheckException must not chain a cause");
    }

    @Override
    public Throwable initCause(Throwable cause) {
        throw new UnsupportedOperationException("PreCheckException must not chain a cause");
    }

    @NonNull
    public ResponseCodeEnum responseCode() {
        return this.responseCode;
    }

    @Override
    public String toString() {
        return "PreCheckException{responseCode=" + String.valueOf(this.responseCode) + "}";
    }

    public static void validateTruePreCheck(boolean condition, ResponseCodeEnum errorStatus) throws PreCheckException {
        if (!condition) {
            throw new PreCheckException(errorStatus);
        }
    }

    public static void validateFalsePreCheck(boolean condition, ResponseCodeEnum errorStatus) throws PreCheckException {
        PreCheckException.validateTruePreCheck(!condition, errorStatus);
    }
}

