/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.hiero.consensus.crypto.CryptoConstants;
import org.hiero.consensus.crypto.KeyGeneratingException;

public final class CertificateUtils {
    private static final int SERIAL_NUMBER_BITS = 64;

    private CertificateUtils() {
    }

    public static String distinguishedName(String commonName) {
        String[] commaSeparator = new String[]{""};
        return CertificateUtils.rdn(commaSeparator, "CN", commonName) + CertificateUtils.rdn(commaSeparator, "O", null) + CertificateUtils.rdn(commaSeparator, "STREET", null) + CertificateUtils.rdn(commaSeparator, "L", null) + CertificateUtils.rdn(commaSeparator, "ST", null) + CertificateUtils.rdn(commaSeparator, "C", null) + CertificateUtils.rdn(commaSeparator, "UID", null);
    }

    public static X509Certificate generateCertificate(String distinguishedName, KeyPair pair, String caDistinguishedName, KeyPair caPair, SecureRandom secureRandom, String signatureAlgorithm) throws KeyGeneratingException {
        try {
            JcaX509v3CertificateBuilder v3CertBldr = new JcaX509v3CertificateBuilder(new X500Principal(caDistinguishedName), new BigInteger(64, secureRandom), Date.from(CryptoConstants.DEFAULT_VALID_FROM), Date.from(CryptoConstants.DEFAULT_VALID_TO), new X500Principal(distinguishedName), pair.getPublic());
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(signatureAlgorithm).setProvider("BC");
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(v3CertBldr.build(signerBuilder.build(caPair.getPrivate())));
        }
        catch (CertificateException | OperatorCreationException e) {
            throw new KeyGeneratingException("Could not generate certificate!", e);
        }
    }

    private static String rdn(String[] commaSeparator, String attributeType, String attributeValue) {
        if (attributeValue == null || attributeValue.isEmpty()) {
            return "";
        }
        attributeValue = attributeValue.replace("\\", "\\\\");
        attributeValue = attributeValue.replace("\"", "\\\"");
        attributeValue = attributeValue.replace(",", "\\,");
        attributeValue = attributeValue.replace(";", "\\;");
        attributeValue = attributeValue.replace("<", "\\<");
        attributeValue = attributeValue.replace(">", "\\>");
        attributeValue = attributeValue.replaceAll(" $", "\\ ");
        attributeValue = attributeValue.replaceAll("^ ", "\\ ");
        attributeValue = attributeValue.replaceAll("^#", "\\#");
        String s = commaSeparator[0] + attributeType + "=" + attributeValue;
        commaSeparator[0] = ",";
        return s;
    }
}

