/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.Key;

public enum SigningSchema {
    RSA("RSA", 3072, "SHA384withRSA"),
    ED25519("Ed25519", 255, "Ed25519");

    private final String keyType;
    private final String signingAlgorithm;
    private final int keySizeBits;

    private SigningSchema(@NonNull String keyType, int keySizeBits, String signingAlgorithm) {
        this.keyType = keyType;
        this.signingAlgorithm = signingAlgorithm;
        this.keySizeBits = keySizeBits;
    }

    @NonNull
    public String getKeyType() {
        return this.keyType;
    }

    @NonNull
    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public int getKeySizeBits() {
        return this.keySizeBits;
    }

    public static SigningSchema fromKeyType(@NonNull Key key) {
        String algorithm;
        return switch (algorithm = key.getAlgorithm()) {
            case "RSA" -> RSA;
            case "Ed25519", "EdDSA" -> ED25519;
            default -> throw new IllegalArgumentException("Unsupported key algorithm: " + algorithm);
        };
    }
}

