/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers.builders.internal;

import com.swirlds.component.framework.counters.BackpressureObjectCounter;
import com.swirlds.component.framework.counters.MultiObjectCounter;
import com.swirlds.component.framework.counters.NoOpObjectCounter;
import com.swirlds.component.framework.counters.ObjectCounter;
import com.swirlds.component.framework.counters.StandardObjectCounter;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.schedulers.ExceptionHandlers;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerBuilder;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerConfiguration;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.function.ToLongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractTaskSchedulerBuilder<OUT>
implements TaskSchedulerBuilder<OUT> {
    private static final Logger logger = LogManager.getLogger(AbstractTaskSchedulerBuilder.class);
    protected final TraceableWiringModel model;
    protected TaskSchedulerType type = TaskSchedulerType.SEQUENTIAL;
    protected final String name;
    protected long unhandledTaskCapacity = 1L;
    protected boolean flushingEnabled = false;
    protected boolean squelchingEnabled = false;
    protected boolean externalBackPressure = false;
    protected ObjectCounter onRamp;
    protected ObjectCounter offRamp;
    protected ForkJoinPool pool;
    protected Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    protected String hyperlink;
    protected ToLongFunction<Object> dataCounter = data -> 1L;
    protected boolean unhandledTaskMetricEnabled = false;
    protected boolean busyFractionMetricEnabled = false;
    protected Duration sleepDuration = Duration.ofNanos(100L);
    protected final Metrics metrics;

    public AbstractTaskSchedulerBuilder(@NonNull Metrics metrics, @NonNull TraceableWiringModel model, @NonNull String name, @NonNull ForkJoinPool defaultPool) {
        this.metrics = Objects.requireNonNull(metrics);
        this.model = Objects.requireNonNull(model);
        if (!name.matches("^[a-zA-Z0-9_]*$")) {
            throw new IllegalArgumentException("Illegal name: \"" + name + "\". Task Schedulers name must only contain alphanumeric characters and underscores");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("TaskScheduler name must not be empty");
        }
        this.name = name;
        this.pool = Objects.requireNonNull(defaultPool);
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> configure(@NonNull TaskSchedulerConfiguration configuration) {
        if (configuration.type() != null) {
            this.withType(configuration.type());
        }
        if (configuration.unhandledTaskCapacity() != null) {
            this.withUnhandledTaskCapacity(configuration.unhandledTaskCapacity());
        }
        if (configuration.unhandledTaskMetricEnabled() != null) {
            this.withUnhandledTaskMetricEnabled(configuration.unhandledTaskMetricEnabled());
        }
        if (configuration.busyFractionMetricEnabled() != null) {
            this.withBusyFractionMetricsEnabled(configuration.busyFractionMetricEnabled());
        }
        if (configuration.flushingEnabled() != null) {
            this.withFlushingEnabled(configuration.flushingEnabled());
        }
        if (configuration.squelchingEnabled() != null) {
            this.withSquelchingEnabled(configuration.squelchingEnabled());
        }
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withType(@NonNull TaskSchedulerType type) {
        this.type = Objects.requireNonNull(type);
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withUnhandledTaskCapacity(long unhandledTaskCapacity) {
        this.unhandledTaskCapacity = unhandledTaskCapacity;
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withFlushingEnabled(boolean requireFlushCapability) {
        this.flushingEnabled = requireFlushCapability;
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withSquelchingEnabled(boolean squelchingEnabled) {
        this.squelchingEnabled = squelchingEnabled;
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withOnRamp(@NonNull ObjectCounter onRamp) {
        this.onRamp = Objects.requireNonNull(onRamp);
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withOffRamp(@NonNull ObjectCounter offRamp) {
        this.offRamp = Objects.requireNonNull(offRamp);
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withExternalBackPressure(boolean externalBackPressure) {
        this.externalBackPressure = externalBackPressure;
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withSleepDuration(@NonNull Duration backpressureSleepDuration) {
        if (backpressureSleepDuration.isNegative()) {
            throw new IllegalArgumentException("Backpressure sleep duration must not be negative");
        }
        this.sleepDuration = backpressureSleepDuration;
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withUnhandledTaskMetricEnabled(boolean enabled) {
        this.unhandledTaskMetricEnabled = enabled;
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withBusyFractionMetricsEnabled(boolean enabled) {
        this.busyFractionMetricEnabled = enabled;
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withPool(@NonNull ForkJoinPool pool) {
        this.pool = Objects.requireNonNull(pool);
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withUncaughtExceptionHandler(@NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = Objects.requireNonNull(uncaughtExceptionHandler);
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withHyperlink(@Nullable String hyperlink) {
        this.hyperlink = hyperlink;
        return this;
    }

    @Override
    @NonNull
    public AbstractTaskSchedulerBuilder<OUT> withDataCounter(@NonNull ToLongFunction<Object> counter) {
        this.dataCounter = counter;
        return this;
    }

    @NonNull
    protected Thread.UncaughtExceptionHandler buildUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandlerOr(ExceptionHandlers.defaultExceptionHandler(this.name));
    }

    @NonNull
    protected Thread.UncaughtExceptionHandler uncaughtExceptionHandlerOr(@NonNull Thread.UncaughtExceptionHandler or) {
        return Objects.requireNonNullElse(this.uncaughtExceptionHandler, or);
    }

    @NonNull
    protected static ObjectCounter combineCounters(@Nullable ObjectCounter innerCounter, @Nullable ObjectCounter outerCounter) {
        if (innerCounter == null) {
            if (outerCounter == null) {
                return NoOpObjectCounter.getInstance();
            }
            return outerCounter;
        }
        if (outerCounter == null) {
            return innerCounter;
        }
        return new MultiObjectCounter(innerCounter, outerCounter);
    }

    @NonNull
    protected Counters buildCounters() {
        if (this.type == TaskSchedulerType.NO_OP) {
            return new Counters(NoOpObjectCounter.getInstance(), NoOpObjectCounter.getInstance());
        }
        ObjectCounter innerCounter = this.model.isBackpressureEnabled() && this.unhandledTaskCapacity != -1L && this.type != TaskSchedulerType.DIRECT && this.type != TaskSchedulerType.DIRECT_THREADSAFE ? new BackpressureObjectCounter(this.name, this.unhandledTaskCapacity, this.sleepDuration) : (this.unhandledTaskMetricEnabled || this.flushingEnabled ? new StandardObjectCounter(this.sleepDuration) : null);
        return new Counters(AbstractTaskSchedulerBuilder.combineCounters(innerCounter, this.onRamp), AbstractTaskSchedulerBuilder.combineCounters(innerCounter, this.offRamp));
    }

    protected record Counters(@NonNull ObjectCounter onRamp, @NonNull ObjectCounter offRamp) {
    }
}

