/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2Frame;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Settings;

public final class Http2Ping
implements Http2Frame<Http2Flag.PingFlags> {
    private static final byte[] EMPTY_PING_DATA = new byte[8];
    private final BufferData data;

    Http2Ping(BufferData data) {
        this.data = data;
    }

    public static Http2Ping create(BufferData data) {
        return new Http2Ping(data);
    }

    public static Http2Ping create() {
        return new Http2Ping(BufferData.create((byte[])EMPTY_PING_DATA));
    }

    @Override
    public Http2FrameData toFrameData(Http2Settings settings, int streamId, Http2Flag.PingFlags flags) {
        Http2FrameHeader header = Http2FrameHeader.create(this.data.available(), this.frameTypes(), flags, streamId);
        return new Http2FrameData(header, this.data);
    }

    public Http2FrameData toFrameData() {
        Http2FrameHeader header = Http2FrameHeader.create(this.data.available(), this.frameTypes(), Http2Flag.PingFlags.create(0), 0);
        return new Http2FrameData(header, this.data);
    }

    @Override
    public String name() {
        return Http2FrameType.PING.name();
    }

    @Override
    public Http2FrameType frameType() {
        return Http2FrameType.PING;
    }

    @Override
    public Http2FrameTypes<Http2Flag.PingFlags> frameTypes() {
        return Http2FrameTypes.PING;
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.data.available()];
        this.data.read(result, 0, result.length);
        this.data.rewind();
        return result;
    }

    public BufferData data() {
        return this.data;
    }
}

