/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.common;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.contract.InternalCallContext;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hyperledger.besu.evm.frame.MessageFrame;

public interface Call {
    @NonNull
    default public PricedResult execute() {
        throw new UnsupportedOperationException("Prefer an explicit execute(MessageFrame) override");
    }

    @NonNull
    default public PricedResult execute(MessageFrame frame) {
        return this.execute();
    }

    default public boolean allowsStaticFrame() {
        return false;
    }

    @NonNull
    default public SchedulableTransactionBody asSchedulableDispatchIn() {
        throw new UnsupportedOperationException("Needs scheduleNative() support");
    }

    public void setSystemContractMethod(@NonNull SystemContractMethod var1);

    public SystemContractMethod getSystemContractMethod();

    public record PricedResult(FullResult fullResult, long nonGasCost, ResponseCodeEnum responseCode, boolean isViewCall) {
        public static PricedResult gasOnly(FullResult result, ResponseCodeEnum responseCode, boolean isViewCall) {
            return new PricedResult(result, 0L, responseCode, isViewCall);
        }

        public static PricedResult gasPlus(FullResult result, ResponseCodeEnum responseCode, boolean isViewCall, long nonGasCost) {
            return new PricedResult(result, nonGasCost, responseCode, isViewCall);
        }

        public ContractFunctionResult asResultOfInsufficientGasRemaining(@NonNull AccountID senderId, @NonNull ContractID contractId, @NonNull Bytes functionParameters, long remainingGas) {
            return ContractFunctionResult.newBuilder().contractID(contractId).amount(this.nonGasCost).contractCallResult(Bytes.EMPTY).errorMessage(ResponseCodeEnum.INSUFFICIENT_GAS.protoName()).gasUsed(this.fullResult().gasRequirement()).gas(remainingGas).functionParameters(functionParameters).senderId(senderId).build();
        }

        public EvmTransactionResult txAsResultOfInsufficientGasRemaining(@NonNull AccountID senderId, @NonNull ContractID contractId, @NonNull Bytes functionParameters, long remainingGas) {
            return EvmTransactionResult.newBuilder().senderId(senderId).contractId(contractId).internalCallContext(InternalCallContext.newBuilder().callData(functionParameters).gas(remainingGas).value(this.nonGasCost)).resultData(Bytes.EMPTY).errorMessage(ResponseCodeEnum.INSUFFICIENT_GAS.protoName()).gasUsed(this.fullResult().gasRequirement()).build();
        }

        public ContractFunctionResult asResultOfCall(@NonNull AccountID senderId, @NonNull ContractID contractId, @NonNull Bytes functionParameters, long remainingGas) {
            String errorMessage = this.responseCode == ResponseCodeEnum.SUCCESS ? "" : this.responseCode.protoName();
            return ContractFunctionResult.newBuilder().contractID(contractId).amount(this.nonGasCost).contractCallResult(ConversionUtils.tuweniToPbjBytes(this.fullResult.output())).errorMessage(errorMessage).gasUsed(this.fullResult().gasRequirement()).gas(remainingGas).functionParameters(functionParameters).senderId(senderId).build();
        }

        public EvmTransactionResult txAsResultOfCall(@NonNull AccountID senderId, @NonNull ContractID contractId, @NonNull Bytes functionParameters, long remainingGas) {
            String errorMessage = this.responseCode == ResponseCodeEnum.SUCCESS ? "" : this.responseCode.protoName();
            return EvmTransactionResult.newBuilder().contractId(contractId).senderId(senderId).internalCallContext(InternalCallContext.newBuilder().callData(functionParameters).gas(remainingGas).value(this.nonGasCost)).resultData(ConversionUtils.tuweniToPbjBytes(this.fullResult.output())).errorMessage(errorMessage).gasUsed(this.fullResult().gasRequirement()).build();
        }
    }
}

