/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl;

import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.schedule.ScheduledCounts;
import com.hedera.hapi.node.state.schedule.ScheduledOrder;
import com.hedera.node.app.service.schedule.ExecutableTxn;
import com.hedera.node.app.service.schedule.ExecutableTxnIterator;
import com.hedera.node.app.service.schedule.ScheduleService;
import com.hedera.node.app.service.schedule.ScheduleServiceApi;
import com.hedera.node.app.service.schedule.ScheduleStreamBuilder;
import com.hedera.node.app.service.schedule.WritableScheduleStore;
import com.hedera.node.app.service.schedule.impl.DaggerScheduleServiceComponent;
import com.hedera.node.app.service.schedule.impl.ScheduleServiceComponent;
import com.hedera.node.app.service.schedule.impl.calculator.ScheduleCreateFeeCalculator;
import com.hedera.node.app.service.schedule.impl.calculator.ScheduleDeleteFeeCalculator;
import com.hedera.node.app.service.schedule.impl.calculator.ScheduleGetInfoFeeCalculator;
import com.hedera.node.app.service.schedule.impl.calculator.ScheduleSignFeeCalculator;
import com.hedera.node.app.service.schedule.impl.handlers.AbstractScheduleHandler;
import com.hedera.node.app.service.schedule.impl.handlers.HandlerUtility;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleHandlers;
import com.hedera.node.app.service.schedule.impl.schemas.V0490ScheduleSchema;
import com.hedera.node.app.service.schedule.impl.schemas.V0570ScheduleSchema;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.hedera.node.app.spi.fees.QueryFeeCalculator;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.store.StoreFactory;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class ScheduleServiceImpl
implements ScheduleService {
    private final ScheduleServiceComponent component;

    public ScheduleServiceImpl(@NonNull AppContext appContext) {
        Objects.requireNonNull(appContext);
        this.component = DaggerScheduleServiceComponent.factory().create(appContext.instantSource(), appContext.throttleFactory(), appContext.idFactory(), appContext.feeChargingSupplier());
    }

    public ServiceApiProvider<ScheduleServiceApi> apiProvider() {
        return this.component.scheduleServiceApiProvider();
    }

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        registry.register((Schema)new V0490ScheduleSchema());
        registry.register((Schema)new V0570ScheduleSchema());
    }

    public ScheduleHandlers handlers() {
        return this.component.handlers();
    }

    public ExecutableTxnIterator executableTxns(@NonNull Instant start, @NonNull Instant end, @NonNull StoreFactory storeFactory) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        Objects.requireNonNull(storeFactory);
        return new PurgingIterator(start.getEpochSecond(), end.getEpochSecond(), storeFactory);
    }

    private static ExecutableTxn<ScheduleStreamBuilder> executableTxnFrom(@NonNull ReadableAccountStore accountStore, @NonNull Schedule schedule) {
        return new ExecutableTxn(HandlerUtility.childAsOrdinary(schedule), schedule.payerAccountIdOrThrow(), AbstractScheduleHandler.simpleKeyVerifierFrom(accountStore, schedule.signatories()), Instant.ofEpochSecond(schedule.calculatedExpirationSecond()), ScheduleStreamBuilder.class, builder -> builder.scheduleRef(schedule.scheduleIdOrThrow()));
    }

    public Set<ServiceFeeCalculator> serviceFeeCalculators() {
        return Set.of(new ScheduleCreateFeeCalculator(), new ScheduleSignFeeCalculator(), new ScheduleDeleteFeeCalculator());
    }

    public Set<QueryFeeCalculator> queryFeeCalculators() {
        return Set.of(new ScheduleGetInfoFeeCalculator());
    }

    private static class PurgingIterator
    implements ExecutableTxnIterator {
        private static final int LOOP_INVARIANT_LIMIT = 8640000;
        private static final Comparator<ScheduledOrder> ORDER_COMPARATOR = Comparator.comparingLong(ScheduledOrder::expirySecond).thenComparingInt(ScheduledOrder::orderNumber);
        private final long startSecond;
        private final long endSecond;
        private final StoreFactory storeFactory;
        private final WritableScheduleStore scheduleStore;
        private boolean nextKnown = false;
        @Nullable
        private ScheduledOrder nextOrder;
        @Nullable
        private Schedule nextSchedule;
        @Nullable
        private ScheduledOrder previousOrder;
        @Nullable
        private ScheduledOrder candidateOrder;

        public PurgingIterator(long startSecond, long endSecond, @NonNull StoreFactory storeFactory) {
            this.startSecond = startSecond;
            this.endSecond = endSecond;
            this.storeFactory = Objects.requireNonNull(storeFactory);
            this.scheduleStore = (WritableScheduleStore)storeFactory.writableStore(WritableScheduleStore.class);
        }

        public boolean hasNext() {
            return this.prepNext() != null;
        }

        public ExecutableTxn<ScheduleStreamBuilder> next() {
            if (!this.nextKnown) {
                this.prepNext();
            }
            this.nextKnown = false;
            if (this.nextSchedule == null) {
                throw new NoSuchElementException();
            }
            return ScheduleServiceImpl.executableTxnFrom((ReadableAccountStore)this.storeFactory.readableStore(ReadableAccountStore.class), this.nextSchedule);
        }

        public void remove() {
            if (this.nextOrder == null) {
                throw new IllegalStateException("remove() called before next()");
            }
            if (this.candidateOrder != null && ORDER_COMPARATOR.compare(this.candidateOrder, this.nextOrder) > 0) {
                throw new IllegalStateException("remove() called twice");
            }
            ScheduledOrder order = Objects.requireNonNull(this.previousOrder);
            int i = 8640000;
            while (ORDER_COMPARATOR.compare(order, this.nextOrder) <= 0) {
                boolean lastOfSecond = this.scheduleStore.purgeByOrder(order);
                order = this.next(order, lastOfSecond);
                if (--i != 0) continue;
                throw new IllegalStateException("Loop invariant limit exceeded during remove() after comparing " + String.valueOf(order) + " to " + String.valueOf(this.nextOrder));
            }
            this.candidateOrder = order;
            this.previousOrder = null;
        }

        public boolean purgeUntilNext() {
            if (!this.nextKnown) {
                throw new IllegalStateException("purgeUntilNext() called before hasNext()");
            }
            if (this.previousOrder != null) {
                ScheduledOrder order = this.previousOrder;
                ScheduledOrder boundaryOrder = this.nextOrder != null ? this.nextOrder : new ScheduledOrder(this.endSecond + 1L, 0);
                int i = 8640000;
                while (ORDER_COMPARATOR.compare(order, boundaryOrder) < 0) {
                    boolean lastOfSecond = this.scheduleStore.purgeByOrder(order);
                    order = this.next(order, lastOfSecond);
                    if (--i != 0) continue;
                    throw new IllegalStateException("Loop invariant limit exceeded during purgeUntilNext() after comparing " + String.valueOf(order) + " to " + String.valueOf(boundaryOrder));
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        private ScheduledOrder prepNext() {
            ScheduledCounts startCounts;
            if (this.nextKnown) {
                return this.nextOrder;
            }
            this.nextOrder = null;
            this.nextSchedule = null;
            this.previousOrder = null;
            ScheduledOrder order = this.candidateOrder != null ? this.candidateOrder : ((startCounts = this.scheduleStore.scheduledCountsAt(this.startSecond)) == null ? new ScheduledOrder(this.startSecond + 1L, 0) : new ScheduledOrder(this.startSecond, startCounts.numberProcessed()));
            int i = 8640000;
            while (order.expirySecond() <= this.endSecond) {
                block6: {
                    ScheduleID nextId = this.scheduleStore.getByOrder(order);
                    if (nextId != null) {
                        Schedule schedule;
                        if (this.previousOrder == null) {
                            this.previousOrder = order;
                        }
                        if (!(schedule = Objects.requireNonNull(this.scheduleStore.get(nextId))).waitForExpiry() || schedule.deleted()) {
                            order = this.next(order, false);
                            break block6;
                        } else {
                            this.nextOrder = order;
                            this.nextSchedule = schedule;
                            break;
                        }
                    }
                    order = this.next(order, true);
                }
                if (--i != 0) continue;
                throw new IllegalStateException("Loop invariant limit exceeded during prepNext() after comparing " + String.valueOf(order) + " expiry second to " + this.endSecond);
            }
            this.nextKnown = true;
            return this.nextOrder;
        }

        private ScheduledOrder next(@NonNull ScheduledOrder order, boolean lastInSecond) {
            return lastInSecond ? new ScheduledOrder(order.expirySecond() + 1L, 0) : order.copyBuilder().orderNumber(order.orderNumber() + 1).build();
        }
    }
}

