/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.snapshot;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.time.Time;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.InsufficientSignaturesPayload;
import com.swirlds.platform.state.snapshot.SavedStateInfo;
import com.swirlds.platform.state.snapshot.SavedStateMetadata;
import com.swirlds.platform.state.snapshot.SignedStateFilePath;
import com.swirlds.platform.state.snapshot.SignedStateFileWriter;
import com.swirlds.platform.state.snapshot.StateDumpRequest;
import com.swirlds.platform.state.snapshot.StateSnapshotManager;
import com.swirlds.platform.state.snapshot.StateSnapshotManagerMetrics;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.Threshold;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.state.StateSavingResult;
import org.hiero.consensus.roster.RosterUtils;
import org.hiero.consensus.state.config.StateConfig;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;
import org.hiero.consensus.state.snapshot.StateToDiskReason;

public class DefaultStateSnapshotManager
implements StateSnapshotManager {
    private static final Logger logger = LogManager.getLogger(DefaultStateSnapshotManager.class);
    private final NodeId selfId;
    private final String mainClassName;
    private final String swirldName;
    private final StateSnapshotManagerMetrics metrics;
    private final Configuration configuration;
    private final PlatformContext platformContext;
    private final Time time;
    private final SignedStateFilePath signedStateFilePath;
    private final StateLifecycleManager stateLifecycleManager;

    public DefaultStateSnapshotManager(@NonNull PlatformContext platformContext, @NonNull String mainClassName, @NonNull NodeId selfId, @NonNull String swirldName, @NonNull StateLifecycleManager stateLifecycleManager) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.time = platformContext.getTime();
        this.selfId = Objects.requireNonNull(selfId);
        this.mainClassName = Objects.requireNonNull(mainClassName);
        this.swirldName = Objects.requireNonNull(swirldName);
        this.configuration = platformContext.getConfiguration();
        this.stateLifecycleManager = stateLifecycleManager;
        this.signedStateFilePath = new SignedStateFilePath((StateCommonConfig)this.configuration.getConfigData(StateCommonConfig.class));
        this.metrics = new StateSnapshotManagerMetrics(platformContext);
    }

    @Override
    @Nullable
    public StateSavingResult saveStateTask(@NonNull ReservedSignedState reservedSignedState) {
        StateSavingResult stateSavingResult;
        long start = this.time.nanoTime();
        try (ReservedSignedState reservedSignedState2 = reservedSignedState;){
            SignedState signedState = reservedSignedState.get();
            if (signedState.hasStateBeenSavedToDisk()) {
                logger.info(LogMarker.EXCEPTION.getMarker(), "Not saving signed state for round {} to disk because it has already been saved.", (Object)signedState.getRound());
                StateSavingResult stateSavingResult2 = null;
                return stateSavingResult2;
            }
            this.checkSignatures(signedState);
            boolean success = this.saveStateTask(signedState, this.getSignedStateDir(signedState.getRound()));
            if (!success) {
                StateSavingResult stateSavingResult3 = null;
                return stateSavingResult3;
            }
            signedState.stateSavedToDisk();
            long minBirthRound = this.deleteOldStates();
            stateSavingResult = new StateSavingResult(signedState.getRound(), signedState.isFreezeState(), signedState.getConsensusTimestamp(), minBirthRound);
        }
        this.metrics.getStateToDiskTimeMetric().update((double)TimeUnit.NANOSECONDS.toMillis(this.time.nanoTime() - start));
        this.metrics.getWriteStateToDiskTimeMetric().update((double)TimeUnit.NANOSECONDS.toMillis(this.time.nanoTime() - start));
        return stateSavingResult;
    }

    @Override
    public void dumpStateTask(@NonNull StateDumpRequest request) {
        try (ReservedSignedState reservedSignedState = request.reservedSignedState();){
            SignedState signedState = reservedSignedState.get();
            this.saveStateTask(reservedSignedState.get(), this.signedStateFilePath.getSignedStatesBaseDirectory().resolve(DefaultStateSnapshotManager.getReason(signedState).getDescription()).resolve(String.format("node%d_round%d", this.selfId.id(), signedState.getRound())));
        }
        request.finishedCallback().run();
    }

    @NonNull
    private static StateToDiskReason getReason(@NonNull SignedState state) {
        return Optional.ofNullable(state.getStateToDiskReason()).orElse(StateToDiskReason.UNKNOWN);
    }

    private boolean saveStateTask(@NonNull SignedState state, @NonNull Path directory) {
        try {
            SignedStateFileWriter.writeSignedStateToDisk(this.platformContext, this.selfId, directory, DefaultStateSnapshotManager.getReason(state), state, (StateLifecycleManager<VirtualMapState, VirtualMap>)this.stateLifecycleManager);
            return true;
        }
        catch (Throwable e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Unable to write signed state to disk for round {} to {}.", (Object)state.getRound(), (Object)directory, (Object)e);
            return false;
        }
    }

    private void checkSignatures(@NonNull SignedState reservedState) {
        long signingWeight1 = reservedState.getSigningWeight();
        long totalWeight1 = RosterUtils.computeTotalWeight((Roster)reservedState.getRoster());
        if (reservedState.isComplete() || reservedState.isPcesRound()) {
            return;
        }
        this.metrics.getTotalUnsignedDiskStatesMetric().increment();
        long signingWeight2 = reservedState.getSigningWeight();
        long totalWeight2 = RosterUtils.computeTotalWeight((Roster)reservedState.getRoster());
        if (reservedState.isFreezeState()) {
            double signingWeightPercent = (double)reservedState.getSigningWeight() / (double)RosterUtils.computeTotalWeight((Roster)reservedState.getRoster()) * 100.0;
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Freeze state written to disk for round {} was not fully signed. This is expected.\nCollected signatures representing {}/{} ({}%) weight.\n", (Object)reservedState.getRound(), (Object)reservedState.getSigningWeight(), (Object)RosterUtils.computeTotalWeight((Roster)reservedState.getRoster()), (Object)signingWeightPercent);
        } else {
            double signingWeight1Percent = (double)signingWeight1 / (double)totalWeight1 * 100.0;
            double signingWeight2Percent = (double)signingWeight2 / (double)totalWeight2 * 100.0;
            logger.error(LogMarker.EXCEPTION.getMarker(), (Object)new InsufficientSignaturesPayload("State written to disk for round %d did not have enough signatures.\nThis log adds debug information for #11422.\nPre-check weight: %d/%d (%f%%)  Post-check weight: %d/%d (%f%%)\nPre-check threshold: %s   Post-check threshold: %s".formatted(reservedState.getRound(), signingWeight1, totalWeight1, signingWeight1Percent, signingWeight2, totalWeight2, signingWeight2Percent, Threshold.SUPER_MAJORITY.isSatisfiedBy(signingWeight1, totalWeight1), Threshold.SUPER_MAJORITY.isSatisfiedBy(signingWeight2, totalWeight2))));
        }
    }

    @NonNull
    private Path getSignedStateDir(long round) {
        return this.signedStateFilePath.getSignedStateDirectory(this.mainClassName, this.selfId, this.swirldName, round);
    }

    private long deleteOldStates() {
        int index;
        List<SavedStateInfo> savedStates = this.signedStateFilePath.getSavedStateFiles(this.mainClassName, this.selfId, this.swirldName);
        StateConfig stateConfig = (StateConfig)this.configuration.getConfigData(StateConfig.class);
        for (index = savedStates.size() - 1; index >= stateConfig.signedStateDisk(); --index) {
            SavedStateInfo savedStateInfo = savedStates.get(index);
            try {
                FileUtils.deleteDirectoryAndLog((Path)savedStateInfo.stateDirectory());
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (index < 0) {
            return -1L;
        }
        SavedStateMetadata oldestStateMetadata = savedStates.get(index).metadata();
        return oldestStateMetadata.minimumBirthRoundNonAncient();
    }
}

