/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.hapi.node.state.hints.HintsConstruction;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.node.app.hints.HintsService;
import com.hedera.node.app.history.HistoryLibrary;
import com.hedera.node.app.history.HistoryService;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.impl.HistoryProver;
import com.hedera.node.app.history.impl.HistorySubmissions;
import com.hedera.node.app.history.impl.InertProofController;
import com.hedera.node.app.history.impl.ProofController;
import com.hedera.node.app.history.impl.ProofControllerImpl;
import com.hedera.node.app.history.impl.ProofKeysAccessor;
import com.hedera.node.app.history.impl.ProofKeysAccessorImpl;
import com.hedera.node.app.history.impl.WrapsHistoryProver;
import com.hedera.node.app.history.impl.WrapsMpcStateMachine;
import com.hedera.node.app.service.roster.impl.ActiveRosters;
import com.hedera.node.app.service.roster.impl.RosterTransitionWeights;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProofControllers {
    private static final long NO_CONSTRUCTION_ID = -1L;
    private final Executor executor;
    private final ProofKeysAccessor keyAccessor;
    private final HistoryLibrary historyLibrary;
    private final HistoryService historyService;
    private final HistorySubmissions submissions;
    private final WrapsMpcStateMachine machine;
    private final Supplier<NodeInfo> selfNodeInfoSupplier;
    @Nullable
    private ProofController controller;

    @Inject
    public ProofControllers(@NonNull Executor executor, @NonNull ProofKeysAccessor keyAccessor, @NonNull HistoryLibrary historyLibrary, @NonNull HistorySubmissions submissions, @NonNull Supplier<NodeInfo> selfNodeInfoSupplier, @NonNull HistoryService historyService, @NonNull WrapsMpcStateMachine machine) {
        this.executor = Objects.requireNonNull(executor);
        this.keyAccessor = Objects.requireNonNull(keyAccessor);
        this.historyLibrary = Objects.requireNonNull(historyLibrary);
        this.submissions = Objects.requireNonNull(submissions);
        this.selfNodeInfoSupplier = Objects.requireNonNull(selfNodeInfoSupplier);
        this.historyService = Objects.requireNonNull(historyService);
        this.machine = Objects.requireNonNull(machine);
    }

    @NonNull
    public ProofController getOrCreateFor(@NonNull ActiveRosters activeRosters, @NonNull HistoryProofConstruction construction, @NonNull ReadableHistoryStore historyStore, @Nullable HintsConstruction activeHintsConstruction, @NonNull HistoryProofConstruction activeProofConstruction, @NonNull TssConfig tssConfig) {
        Objects.requireNonNull(activeRosters);
        Objects.requireNonNull(construction);
        Objects.requireNonNull(historyStore);
        Objects.requireNonNull(activeProofConstruction);
        if (this.currentConstructionId() != construction.constructionId()) {
            if (this.controller != null) {
                this.controller.cancelPendingWork();
            }
            this.controller = this.newControllerFor(activeRosters, construction, historyStore, activeHintsConstruction, activeProofConstruction, tssConfig);
        }
        return Objects.requireNonNull(this.controller);
    }

    public Optional<ProofController> getInProgressById(long constructionId, @NonNull TssConfig tssConfig) {
        return this.currentConstructionId() == constructionId ? Optional.ofNullable(this.controller).filter(pc -> pc.isStillInProgress(tssConfig)) : Optional.empty();
    }

    public Optional<ProofController> getAnyInProgress(@NonNull TssConfig tssConfig) {
        return Optional.ofNullable(this.controller).filter(pc -> pc.isStillInProgress(tssConfig));
    }

    private ProofController newControllerFor(@NonNull ActiveRosters activeRosters, @NonNull HistoryProofConstruction construction, @NonNull ReadableHistoryStore historyStore, @Nullable HintsConstruction activeHintsConstruction, @NonNull HistoryProofConstruction activeProofConstruction, @NonNull TssConfig tssConfig) {
        RosterTransitionWeights weights = activeRosters.transitionWeights(HintsService.maybeWeightsFrom(activeHintsConstruction));
        if (!weights.sourceNodesHaveTargetThreshold()) {
            return new InertProofController(construction.constructionId());
        }
        List<ReadableHistoryStore.ProofKeyPublication> keyPublications = historyStore.getProofKeyPublications(weights.targetNodeIds());
        List<ReadableHistoryStore.WrapsMessagePublication> wrapsMessagePublications = historyStore.getWrapsMessagePublications(construction.constructionId(), weights.targetNodeIds());
        Map<Long, HistoryProofVote> votes = historyStore.getVotes(construction.constructionId(), weights.sourceNodeIds());
        long selfId = this.selfNodeInfoSupplier.get().nodeId();
        ProofKeysAccessorImpl.SchnorrKeyPair schnorrKeyPair = this.keyAccessor.getOrCreateSchnorrKeyPair(construction.constructionId());
        HistoryProof sourceProof = activeProofConstruction.targetProof();
        HistoryProver.Factory proverFactory = (s, t, k, p, w, r, x, l, m) -> new WrapsHistoryProver(s, t.wrapsMessageGracePeriod(), k, p, w, r, CompletableFuture::delayedExecutor, x, l, m, this.machine);
        return new ProofControllerImpl(selfId, schnorrKeyPair, construction, weights, this.executor, this.submissions, this.machine, keyPublications, wrapsMessagePublications, votes, this.historyService, this.historyLibrary, proverFactory, sourceProof, tssConfig);
    }

    public static boolean isWrapsExtensible(@Nullable HistoryProof proof) {
        return proof != null && !Bytes.EMPTY.equals((Object)proof.uncompressedWrapsProof());
    }

    private long currentConstructionId() {
        return this.controller != null ? this.controller.constructionId() : -1L;
    }
}

