/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.merkle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.node.app.state.merkle.SchemaApplicationType;
import com.hedera.node.app.state.merkle.VersionUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.Schema;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class SchemaApplications {
    public Set<SchemaApplicationType> computeApplications(@Nullable SemanticVersion deserializedVersion, @NonNull SemanticVersion latestVersion, @NonNull Schema<SemanticVersion> schema, @NonNull Configuration config) {
        Objects.requireNonNull(schema);
        Objects.requireNonNull(config);
        Objects.requireNonNull(latestVersion);
        EnumSet<SchemaApplicationType> uses = EnumSet.noneOf(SchemaApplicationType.class);
        if (this.hasStateDefinitions(schema, config)) {
            uses.add(SchemaApplicationType.STATE_DEFINITIONS);
        }
        if (!VersionUtils.alreadyIncludesStateDefs(deserializedVersion, (SemanticVersion)schema.getVersion())) {
            uses.add(SchemaApplicationType.MIGRATION);
        }
        if (VersionUtils.isSameVersion(latestVersion, (SemanticVersion)schema.getVersion())) {
            uses.add(SchemaApplicationType.RESTART);
        }
        return uses;
    }

    private boolean hasStateDefinitions(@NonNull Schema<?> schema, @NonNull Configuration config) {
        return !schema.statesToCreate(config).isEmpty() || !schema.statesToRemove().isEmpty();
    }
}

