/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.io.extendable.extensions;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.io.extendable.extensions.AbstractStreamExtension;

public class HashingStreamExtension
extends AbstractStreamExtension {
    private final DigestType digestType;
    private final MessageDigest digest;
    private volatile boolean enabled;

    public HashingStreamExtension(DigestType digestType) {
        this.digestType = digestType;
        try {
            this.digest = MessageDigest.getInstance(digestType.algorithmName(), digestType.provider());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        this.enabled = false;
    }

    public void startHashing() {
        this.enabled = true;
    }

    public Hash finishHashing() {
        return new Hash(this.digest.digest(), this.digestType);
    }

    @Override
    public void newByte(int aByte) {
        if (this.enabled) {
            this.digest.update((byte)aByte);
        }
    }

    @Override
    public void newBytes(byte[] bytes, int offset, int length) {
        if (this.enabled) {
            this.digest.update(bytes, offset, length);
        }
    }
}

