/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.core;

import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;

public final class GrpcHelper {
    private GrpcHelper() {
    }

    public static String extractServiceName(String fullMethodName) {
        int index = fullMethodName.indexOf(47);
        return index == -1 ? fullMethodName : fullMethodName.substring(0, index);
    }

    public static String extractNamePrefix(String fullMethodName) {
        int index = fullMethodName.lastIndexOf(47);
        return index == -1 ? fullMethodName : fullMethodName.substring(0, index);
    }

    public static String extractMethodName(String fullMethodName) {
        int index = fullMethodName.lastIndexOf(47);
        return index == -1 ? fullMethodName : fullMethodName.substring(index + 1);
    }

    public static io.helidon.http.Status toHttpResponseStatus(StatusException ex) {
        return GrpcHelper.toHttpResponseStatus(ex.getStatus());
    }

    public static io.helidon.http.Status toHttpResponseStatus(StatusRuntimeException ex) {
        return GrpcHelper.toHttpResponseStatus(ex.getStatus());
    }

    public static io.helidon.http.Status toHttpResponseStatus(Status status) {
        return switch (status.getCode()) {
            case Status.Code.OK -> io.helidon.http.Status.create((int)200, (String)status.getDescription());
            case Status.Code.INVALID_ARGUMENT, Status.Code.OUT_OF_RANGE -> io.helidon.http.Status.create((int)400, (String)status.getDescription());
            case Status.Code.DEADLINE_EXCEEDED -> io.helidon.http.Status.create((int)408, (String)status.getDescription());
            case Status.Code.NOT_FOUND -> io.helidon.http.Status.create((int)404, (String)status.getDescription());
            case Status.Code.ALREADY_EXISTS -> io.helidon.http.Status.create((int)412, (String)status.getDescription());
            case Status.Code.PERMISSION_DENIED -> io.helidon.http.Status.create((int)403, (String)status.getDescription());
            case Status.Code.FAILED_PRECONDITION -> io.helidon.http.Status.create((int)412, (String)status.getDescription());
            case Status.Code.UNIMPLEMENTED -> io.helidon.http.Status.create((int)501, (String)status.getDescription());
            case Status.Code.UNAVAILABLE -> io.helidon.http.Status.create((int)503, (String)status.getDescription());
            case Status.Code.UNAUTHENTICATED -> io.helidon.http.Status.create((int)401, (String)status.getDescription());
            default -> io.helidon.http.Status.create((int)500, (String)status.getDescription());
        };
    }

    public static Throwable ensureStatusException(Throwable thrown, Status status) {
        if (thrown instanceof StatusRuntimeException || thrown instanceof StatusException) {
            return thrown;
        }
        return status.withCause(thrown).asException();
    }

    public static StatusRuntimeException ensureStatusRuntimeException(Throwable thrown, Status status) {
        if (thrown instanceof StatusRuntimeException) {
            return (StatusRuntimeException)thrown;
        }
        if (thrown instanceof StatusException) {
            StatusException ex = (StatusException)thrown;
            return new StatusRuntimeException(ex.getStatus(), ex.getTrailers());
        }
        return status.withCause(thrown).asRuntimeException();
    }
}

