/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer.customfees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessmentResult;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFeeExemptions;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class AdjustmentUtils {
    public static final Function<TokenID, Map<AccountID, Long>> ADJUSTMENTS_MAP_FACTORY = ignore -> new LinkedHashMap();

    private AdjustmentUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static long safeFractionMultiply(long numerator, long denominator, long amount) throws ArithmeticException {
        if (amount != 0L && numerator > Long.MAX_VALUE / amount) {
            return BigInteger.valueOf(amount).multiply(BigInteger.valueOf(numerator)).divide(BigInteger.valueOf(denominator)).longValueExact();
        }
        return numerator * amount / denominator;
    }

    public static CustomFee asFixedFee(long unitsToCollect, TokenID tokenDenomination, AccountID feeCollector, boolean allCollectorsAreExempt) {
        Objects.requireNonNull(feeCollector);
        FixedFee spec = FixedFee.newBuilder().denominatingTokenId(tokenDenomination).amount(unitsToCollect).build();
        return CustomFee.newBuilder().fixedFee(spec).feeCollectorAccountId(feeCollector).allCollectorsAreExempt(allCollectorsAreExempt).build();
    }

    public static void adjustHtsFees(AssessmentResult result, AccountID sender, AccountID collector, Token token, long amount, TokenID denominatingToken) {
        Map<TokenID, Map<AccountID, Long>> newHtsAdjustments = result.getHtsAdjustments();
        Map<TokenID, Map<AccountID, Long>> inputHtsAdjustments = result.getMutableInputBalanceAdjustments();
        if (token.tokenId().equals((Object)denominatingToken)) {
            AdjustmentUtils.addHtsAdjustment(inputHtsAdjustments, sender, collector, amount, denominatingToken);
        } else {
            AdjustmentUtils.addHtsAdjustment(newHtsAdjustments, sender, collector, amount, denominatingToken);
        }
    }

    private static void addHtsAdjustment(Map<TokenID, Map<AccountID, Long>> htsAdjustments, AccountID sender, AccountID collector, long amount, TokenID denominatingToken) {
        Map<AccountID, Long> denominatingTokenMap = htsAdjustments.computeIfAbsent(denominatingToken, ADJUSTMENTS_MAP_FACTORY);
        denominatingTokenMap.merge(sender, -amount, AdjustmentUtils::addExactOrThrow);
        denominatingTokenMap.merge(collector, amount, AdjustmentUtils::addExactOrThrow);
        htsAdjustments.put(denominatingToken, denominatingTokenMap);
    }

    public static Map<AccountID, Long> getFungibleTokenCredits(Map<AccountID, Long> tokenIdChanges) {
        LinkedHashMap<AccountID, Long> credits = new LinkedHashMap<AccountID, Long>();
        for (Map.Entry<AccountID, Long> entry : tokenIdChanges.entrySet()) {
            AccountID account = entry.getKey();
            Long amount = entry.getValue();
            if (amount <= 0L) continue;
            credits.put(account, amount);
        }
        return credits;
    }

    public static Map<AccountID, Long> getNonExemptTokenDebits(@NonNull Map<AccountID, Long> tokenIdChanges, @NonNull Token token, @NonNull CustomFee fee) {
        LinkedHashMap<AccountID, Long> nonExemptDebits = new LinkedHashMap<AccountID, Long>();
        for (Map.Entry<AccountID, Long> entry : tokenIdChanges.entrySet()) {
            AccountID account = entry.getKey();
            Long amount = entry.getValue();
            if (amount >= 0L || CustomFeeExemptions.isPayerExempt(token, fee, account)) continue;
            nonExemptDebits.put(account, -amount.longValue());
        }
        return nonExemptDebits;
    }

    public static List<ExchangedValue> getFungibleCredits(AssessmentResult result, AccountID sender) {
        Map<TokenID, Map<AccountID, Long>> tokenChanges = result.getImmutableInputTokenAdjustments();
        ArrayList<ExchangedValue> credits = new ArrayList<ExchangedValue>();
        for (Map.Entry<AccountID, Long> entry : result.getImmutableInputHbarAdjustments().entrySet()) {
            AccountID account = entry.getKey();
            Long amount = entry.getValue();
            if (amount <= 0L || !account.equals((Object)sender)) continue;
            credits.add(new ExchangedValue(sender, null, amount));
        }
        for (Map.Entry<Object, Object> entry : tokenChanges.entrySet()) {
            TokenID token = (TokenID)entry.getKey();
            Map map = (Map)entry.getValue();
            if (!map.containsKey(sender) || (Long)map.get(sender) <= 0L) continue;
            credits.add(new ExchangedValue(sender, token, (Long)map.get(sender)));
        }
        return credits;
    }

    public static void adjustHbarFees(AssessmentResult result, AccountID sender, CustomFee hbarFee) {
        Map<AccountID, Long> hbarAdjustments = result.getHbarAdjustments();
        AccountID collector = hbarFee.feeCollectorAccountId();
        FixedFee fixedSpec = hbarFee.fixedFee();
        if (fixedSpec != null) {
            long amount = fixedSpec.amount();
            hbarAdjustments.merge(sender, -amount, AdjustmentUtils::addExactOrThrow);
            hbarAdjustments.merge(collector, amount, AdjustmentUtils::addExactOrThrow);
        }
    }

    public static long addExactOrThrow(long addendA, long addendB) {
        return AdjustmentUtils.addExactOrThrowReason(addendA, addendB, ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE);
    }

    public static long addExactOrThrowReason(long addendA, long addendB, @NonNull ResponseCodeEnum failureReason) {
        try {
            return Math.addExact(addendA, addendB);
        }
        catch (ArithmeticException ignore) {
            throw new HandleException(failureReason);
        }
    }

    public record ExchangedValue(AccountID account, TokenID tokenId, long amount) {
    }
}

