/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountApprovalForAllAllowance;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.CryptoAllowance;
import com.hedera.hapi.node.token.CryptoApproveAllowanceTransactionBody;
import com.hedera.hapi.node.token.NftAllowance;
import com.hedera.hapi.node.token.TokenAllowance;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.AllowanceValidator;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.HederaConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ApproveAllowanceValidator
extends AllowanceValidator {
    @Inject
    public ApproveAllowanceValidator() {
    }

    public void validate(@NonNull HandleContext context, Account payerAccount, ReadableAccountStore accountStore) {
        StoreFactory storeFactory = context.storeFactory();
        ReadableTokenStore tokenStore = (ReadableTokenStore)storeFactory.readableStore(ReadableTokenStore.class);
        ReadableTokenRelationStore tokenRelStore = (ReadableTokenRelationStore)storeFactory.readableStore(ReadableTokenRelationStore.class);
        ReadableNftStore nftStore = (ReadableNftStore)storeFactory.readableStore(ReadableNftStore.class);
        HederaConfig hederaConfig = (HederaConfig)context.configuration().getConfigData(HederaConfig.class);
        TransactionBody txn = context.body();
        CryptoApproveAllowanceTransactionBody op = txn.cryptoApproveAllowanceOrThrow();
        List cryptoAllowances = op.cryptoAllowances();
        List tokenAllowances = op.tokenAllowances();
        List nftAllowances = op.nftAllowances();
        this.validateAllowanceCount(cryptoAllowances, tokenAllowances, nftAllowances, hederaConfig);
        ExpiryValidator expiryValidator = context.expiryValidator();
        this.validateCryptoAllowances(cryptoAllowances, payerAccount, accountStore, expiryValidator);
        this.validateFungibleTokenAllowances(tokenAllowances, payerAccount, accountStore, tokenStore, tokenRelStore, expiryValidator);
        this.validateNftAllowances(nftAllowances, payerAccount, accountStore, tokenStore, tokenRelStore, nftStore, expiryValidator);
    }

    void validateCryptoAllowances(@NonNull List<CryptoAllowance> cryptoAllowances, @NonNull Account payer, @NonNull ReadableAccountStore accountStore, @NonNull ExpiryValidator expiryValidator) {
        for (CryptoAllowance allowance : cryptoAllowances) {
            AccountID owner = allowance.owner();
            AccountID spender = allowance.spenderOrThrow();
            Account effectiveOwner = ApproveAllowanceValidator.getEffectiveOwner(owner, payer, accountStore, expiryValidator);
            Account spenderAccount = accountStore.getAccountById(spender);
            this.validateSpender(allowance.amount(), spenderAccount);
            HandleException.validateFalse((boolean)spender.equals((Object)effectiveOwner.accountId()), (ResponseCodeEnum)ResponseCodeEnum.SPENDER_ACCOUNT_SAME_AS_OWNER);
        }
    }

    private void validateFungibleTokenAllowances(List<TokenAllowance> tokenAllowances, @NonNull Account payer, ReadableAccountStore accountStore, ReadableTokenStore tokenStore, ReadableTokenRelationStore tokenRelStore, @NonNull ExpiryValidator expiryValidator) {
        for (TokenAllowance allowance : tokenAllowances) {
            AccountID owner = allowance.owner();
            AccountID spender = allowance.spenderOrThrow();
            Token token = TokenHandlerHelper.getIfUsable(allowance.tokenIdOrElse(TokenID.DEFAULT), tokenStore, TokenHandlerHelper.TokenValidations.PERMIT_PAUSED);
            Account effectiveOwner = ApproveAllowanceValidator.getEffectiveOwner(owner, payer, accountStore, expiryValidator);
            Account spenderAccount = accountStore.getAccountById(spender);
            HandleException.validateTrue((boolean)TokenType.FUNGIBLE_COMMON.equals((Object)token.tokenType()), (ResponseCodeEnum)ResponseCodeEnum.NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES);
            long amount = allowance.amount();
            this.validateSpender(amount, spenderAccount);
            HandleException.validateFalse((TokenSupplyType.FINITE.equals((Object)token.supplyType()) && amount > token.maxSupply() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY);
            this.validateTokenBasics(effectiveOwner, spender, token, tokenRelStore);
        }
    }

    private void validateNftAllowances(List<NftAllowance> nftAllowancesList, @NonNull Account payer, ReadableAccountStore accountStore, ReadableTokenStore tokenStore, ReadableTokenRelationStore tokenRelStore, ReadableNftStore uniqueTokenStore, @NonNull ExpiryValidator expiryValidator) {
        for (NftAllowance allowance : nftAllowancesList) {
            AccountID owner = allowance.owner();
            AccountID spender = allowance.spenderOrThrow();
            TokenID tokenId = allowance.tokenIdOrThrow();
            List serialNums = allowance.serialNumbers();
            Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore, TokenHandlerHelper.TokenValidations.PERMIT_PAUSED);
            HandleException.validateFalse((boolean)TokenType.FUNGIBLE_COMMON.equals((Object)token.tokenType()), (ResponseCodeEnum)ResponseCodeEnum.FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES);
            Account spenderAccount = accountStore.getAccountById(spender);
            if (Boolean.TRUE.equals(allowance.approvedForAll())) {
                this.validateNFTSpender(spenderAccount);
            } else {
                this.validateNFTSpender(serialNums, spenderAccount);
            }
            Account effectiveOwner = ApproveAllowanceValidator.getEffectiveOwner(owner, payer, accountStore, expiryValidator);
            this.validateTokenBasics(effectiveOwner, spender, token, tokenRelStore);
            if (allowance.hasDelegatingSpender() && allowance.delegatingSpenderOrThrow().accountNumOrThrow() != 0L) {
                TokenHandlerHelper.getIfUsable(allowance.delegatingSpenderOrThrow(), accountStore, expiryValidator, ResponseCodeEnum.INVALID_DELEGATING_SPENDER, ResponseCodeEnum.INVALID_DELEGATING_SPENDER, TokenHandlerHelper.AccountIDType.ALIASED_ID);
                if (allowance.hasApprovedForAll()) {
                    HandleException.validateFalse((boolean)allowance.approvedForAll(), (ResponseCodeEnum)ResponseCodeEnum.DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL);
                }
                AccountApprovalForAllAllowance approveForAllKey = AccountApprovalForAllAllowance.newBuilder().tokenId(tokenId).spenderId(allowance.delegatingSpender()).build();
                HandleException.validateTrue((boolean)effectiveOwner.approveForAllNftAllowances().contains(approveForAllKey), (ResponseCodeEnum)ResponseCodeEnum.DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL);
            }
            this.validateSerialNums(serialNums, tokenId, uniqueTokenStore);
        }
    }

    private void validateAllowanceCount(@NonNull List<CryptoAllowance> cryptoAllowances, @NonNull List<TokenAllowance> tokenAllowances, @NonNull List<NftAllowance> nftAllowances, @NonNull HederaConfig hederaConfig) {
        int totalAllowances = cryptoAllowances.size() + tokenAllowances.size() + ApproveAllowanceValidator.aggregateApproveNftAllowances(nftAllowances);
        this.validateTotalAllowancesPerTxn(totalAllowances, hederaConfig);
    }

    private void validateTokenBasics(Account owner, AccountID spender, Token token, ReadableTokenRelationStore tokenRelStore) {
        AccountID ownerId = owner.accountId();
        TokenID tokenId = token.tokenId();
        HandleException.validateFalse((token.tokenType() != TokenType.FUNGIBLE_COMMON && owner.accountIdOrThrow().equals((Object)spender) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.SPENDER_ACCOUNT_SAME_AS_OWNER);
        TokenRelation relation = tokenRelStore.get(ownerId, tokenId);
        HandleException.validateTrue((relation != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT);
    }

    private void validateSpender(long amount, @Nullable Account spenderAccount) {
        HandleException.validateTrue((amount == 0L || spenderAccount != null && !spenderAccount.deleted() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID);
    }

    private void validateNFTSpender(List<Long> serialNumbers, Account spenderAccount) {
        HandleException.validateTrue((serialNumbers.isEmpty() || spenderAccount != null && !spenderAccount.deleted() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID);
    }

    private void validateNFTSpender(Account spenderAccount) {
        HandleException.validateTrue((spenderAccount != null && !spenderAccount.deleted() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID);
    }
}

