/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.NftRemoveAllowance;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.validators.AllowanceValidator;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.HederaConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DeleteAllowanceValidator
extends AllowanceValidator {
    @Inject
    public DeleteAllowanceValidator() {
    }

    public void validate(HandleContext handleContext, List<NftRemoveAllowance> nftAllowances, Account payerAccount, ReadableAccountStore accountStore) {
        StoreFactory storeFactory = handleContext.storeFactory();
        ReadableTokenStore tokenStore = (ReadableTokenStore)storeFactory.readableStore(ReadableTokenStore.class);
        ReadableTokenRelationStore tokenRelStore = (ReadableTokenRelationStore)storeFactory.readableStore(ReadableTokenRelationStore.class);
        ReadableNftStore nftStore = (ReadableNftStore)storeFactory.readableStore(ReadableNftStore.class);
        HederaConfig hederaConfig = (HederaConfig)handleContext.configuration().getConfigData(HederaConfig.class);
        this.validateAllowancesCount(nftAllowances, hederaConfig);
        this.validateNftDeleteAllowances(nftAllowances, payerAccount, accountStore, tokenStore, tokenRelStore, nftStore, handleContext.expiryValidator());
    }

    private void validateNftDeleteAllowances(List<NftRemoveAllowance> nftAllowances, Account payerAccount, ReadableAccountStore accountStore, ReadableTokenStore tokenStore, ReadableTokenRelationStore tokenRelStore, ReadableNftStore nftStore, @NonNull ExpiryValidator expiryValidator) {
        if (nftAllowances.isEmpty()) {
            return;
        }
        for (NftRemoveAllowance allowance : nftAllowances) {
            AccountID ownerId = allowance.ownerOrElse(AccountID.DEFAULT);
            TokenID tokenId = allowance.tokenIdOrThrow();
            List serialNums = allowance.serialNumbers();
            Token token = tokenStore.get(allowance.tokenIdOrElse(TokenID.DEFAULT));
            HandleException.validateTrue((token != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
            HandleException.validateTrue((!token.deleted() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_WAS_DELETED);
            HandleException.validateFalse((boolean)token.tokenType().equals((Object)TokenType.FUNGIBLE_COMMON), (ResponseCodeEnum)ResponseCodeEnum.FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES);
            Account effectiveOwner = DeleteAllowanceValidator.getEffectiveOwner(ownerId, payerAccount, accountStore, expiryValidator);
            TokenRelation relation = tokenRelStore.get(effectiveOwner.accountId(), token.tokenId());
            HandleException.validateTrue((relation != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT);
            this.validateDeleteSerialNums(serialNums, tokenId, nftStore);
        }
    }

    private void validateDeleteSerialNums(List<Long> serialNums, TokenID tokenId, ReadableNftStore nftStore) {
        HandleException.validateFalse((boolean)serialNums.isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.EMPTY_ALLOWANCES);
        this.validateSerialNums(serialNums, tokenId, nftStore);
    }

    private void validateAllowancesCount(@NonNull List<NftRemoveAllowance> nftAllowances, @NonNull HederaConfig hederaConfig) {
        this.validateTotalAllowancesPerTxn(DeleteAllowanceValidator.aggregateNftDeleteAllowances(nftAllowances), hederaConfig);
    }

    public static int aggregateNftDeleteAllowances(List<NftRemoveAllowance> nftAllowances) {
        int count = 0;
        for (NftRemoveAllowance allowance : nftAllowances) {
            count += allowance.serialNumbers().size();
        }
        return count;
    }
}

