/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees;

import com.hedera.hapi.node.base.Key;
import edu.umd.cs.findbugs.annotations.NonNull;

public final class FeeKeyUtils {
    private FeeKeyUtils() {
    }

    public static long countKeys(@NonNull Key key) {
        return switch ((Key.KeyOneOfType)key.key().kind()) {
            case Key.KeyOneOfType.ED25519, Key.KeyOneOfType.ECDSA_SECP256K1, Key.KeyOneOfType.ECDSA_384 -> 1L;
            case Key.KeyOneOfType.THRESHOLD_KEY -> key.thresholdKeyOrThrow().keys().keys().stream().mapToLong(FeeKeyUtils::countKeys).sum();
            case Key.KeyOneOfType.KEY_LIST -> key.keyListOrThrow().keys().stream().mapToLong(FeeKeyUtils::countKeys).sum();
            default -> 0L;
        };
    }
}

