/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.snapshot;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.utility.Mnemonics;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.StateSavedToDiskPayload;
import com.swirlds.platform.builder.ConsensusModuleBuilder;
import com.swirlds.platform.config.internal.PlatformConfigUtils;
import com.swirlds.platform.state.snapshot.SavedStateMetadata;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.pces.PcesModule;
import org.hiero.consensus.platformstate.PlatformStateUtils;
import org.hiero.consensus.state.signed.SignedState;
import org.hiero.consensus.state.snapshot.StateToDiskReason;

public final class SignedStateFileWriter {
    private static final Logger logger = LogManager.getLogger(SignedStateFileWriter.class);

    private SignedStateFileWriter() {
    }

    public static void writeHashInfoFile(@NonNull PlatformContext platformContext, @NonNull Path directory, @NonNull VirtualMapState state) throws IOException {
        String platformInfo = PlatformStateUtils.getInfoString((State)state);
        logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Information for state written to disk:\n{}", (Object)platformInfo);
        Path hashInfoFile = directory.resolve("hashInfo.txt");
        String hashInfo = Mnemonics.generateMnemonic((Hash)state.getHash());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(hashInfoFile.toFile()));){
            writer.write(String.format("(root) VirtualMap    state    /    %s", hashInfo));
        }
    }

    private static void writeMetadataFile(@Nullable NodeId selfId, @NonNull Path directory, @NonNull SignedState signedState) throws IOException {
        Objects.requireNonNull(directory, "directory must not be null");
        Objects.requireNonNull(signedState, "signedState must not be null");
        Path metadataFile = directory.resolve("stateMetadata.txt");
        SavedStateMetadata.create(signedState, selfId, Instant.now()).write(metadataFile);
    }

    public static void writeSignatureSetFile(@NonNull Path directory, @NonNull SignedState signedState) throws IOException {
        Path sigSetFile = directory.resolve("signatureSet.pbj");
        try (FileOutputStream fos = new FileOutputStream(sigSetFile.toFile());
             WritableStreamingData out = new WritableStreamingData((OutputStream)fos);){
            signedState.getSigSet().serialize(out);
        }
    }

    public static void writeSignedStateFilesToDirectory(@Nullable PlatformContext platformContext, @Nullable NodeId selfId, @NonNull Path directory, @NonNull SignedState signedState, @NonNull StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager) throws IOException {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(directory);
        Objects.requireNonNull(signedState);
        Objects.requireNonNull(stateLifecycleManager);
        long round = PlatformStateUtils.roundOf((State)signedState.getState());
        try {
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Creating a snapshot on demand in {} for {}", (Object)directory, (Object)round);
            stateLifecycleManager.createSnapshot((Object)signedState.getState(), directory);
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Successfully created a snapshot on demand in {}  for {}", (Object)directory, (Object)round);
        }
        catch (Throwable e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Unable to write a snapshot on demand for {} to {}.", (Object)round, (Object)directory, (Object)e);
        }
        SignedStateFileWriter.writeSignatureSetFile(directory, signedState);
        SignedStateFileWriter.writeHashInfoFile(platformContext, directory, signedState.getState());
        SignedStateFileWriter.writeMetadataFile(selfId, directory, signedState);
        Roster currentRoster = signedState.getRoster();
        SignedStateFileWriter.writeRosterFile(directory, currentRoster);
        PlatformConfigUtils.writeSettingsUsed(directory, platformContext.getConfiguration());
        if (selfId != null) {
            PcesModule pcesModule = ConsensusModuleBuilder.createPcesModule();
            pcesModule.copyPcesFilesRetryOnFailure(platformContext.getConfiguration(), selfId, directory, PlatformStateUtils.ancientThresholdOf((State)signedState.getState()), signedState.getRound());
        }
    }

    private static void writeRosterFile(@NonNull Path directory, @NonNull Roster roster) throws IOException {
        Path rosterFile = directory.resolve("currentRoster.json");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(rosterFile.toFile()));){
            writer.write(Roster.JSON.toJSON((Object)roster));
        }
    }

    public static void writeSignedStateToDisk(@NonNull PlatformContext platformContext, @Nullable NodeId selfId, @NonNull Path savedStateDirectory, @Nullable StateToDiskReason stateToDiskReason, @NonNull SignedState signedState, @NonNull StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager) throws IOException {
        Objects.requireNonNull(signedState);
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(savedStateDirectory);
        Objects.requireNonNull(stateLifecycleManager);
        try {
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Started writing round {} state to disk. Reason: {}, directory: {}", (Object)signedState.getRound(), (Object)(stateToDiskReason == null ? "UNKNOWN" : stateToDiskReason), (Object)savedStateDirectory);
            FileUtils.executeAndRename((Path)savedStateDirectory, directory -> SignedStateFileWriter.writeSignedStateFilesToDirectory(platformContext, selfId, directory, signedState, stateLifecycleManager), (Configuration)platformContext.getConfiguration());
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), () -> new StateSavedToDiskPayload(signedState.getRound(), signedState.isFreezeState(), stateToDiskReason == null ? "UNKNOWN" : stateToDiskReason.toString(), savedStateDirectory).toString());
        }
        catch (Throwable e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception when writing the signed state for round {} to disk:", (Object)signedState.getRound(), (Object)e);
            throw e;
        }
    }
}

