/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.utility;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;

public class StringTable {
    private final List<ColumnDef> columns;
    private final List<Object[]> rows = new ArrayList<Object[]>();

    private StringTable(@NonNull List<ColumnDef> columns) {
        this.columns = List.copyOf(columns);
    }

    public void addRow(Object ... values) {
        Object[] fullRow = new Object[this.columns.size()];
        int valueIndex = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            fullRow[i] = this.columns.get((int)i).fixedValue != null ? this.columns.get((int)i).fixedValue : values[valueIndex++];
        }
        this.rows.add(fullRow);
    }

    @NonNull
    public String toString() {
        String[][] formatted = new String[this.rows.size()][this.columns.size()];
        int[] widths = new int[this.columns.size()];
        for (int c = 0; c < this.columns.size(); ++c) {
            ColumnDef col = this.columns.get(c);
            int n = widths[c] = col.header != null ? col.header.length() : 0;
            if (col.fixedValue != null) {
                widths[c] = Math.max(widths[c], col.fixedValue.length());
            }
            if (col.width <= 0) continue;
            widths[c] = Math.max(widths[c], col.width);
        }
        for (int r = 0; r < this.rows.size(); ++r) {
            for (int c = 0; c < this.columns.size(); ++c) {
                formatted[r][c] = StringTable.formatCell(this.columns.get(c), this.rows.get(r)[c]);
                widths[c] = Math.max(widths[c], formatted[r][c].length());
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < this.columns.size(); ++c) {
            if (c > 0) {
                sb.append(' ');
            }
            String headerText = this.columns.get((int)c).header != null ? this.columns.get((int)c).header : "";
            sb.append(StringTable.padRight(headerText, widths[c]));
        }
        sb.append('\n');
        for (String[] row : formatted) {
            for (int c = 0; c < this.columns.size(); ++c) {
                if (c > 0) {
                    sb.append(' ');
                }
                ColumnDef col = this.columns.get(c);
                if (col.type == ColumnType.STRING || col.fixedValue != null) {
                    sb.append(StringTable.padRight(row[c], widths[c]));
                    continue;
                }
                sb.append(StringTable.padLeft(row[c], widths[c]));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @NonNull
    private static String formatCell(@NonNull ColumnDef col, @NonNull Object value) {
        if (col.fixedValue != null) {
            return col.fixedValue;
        }
        return switch (col.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> String.format("%d", ((Number)value).longValue());
            case 2 -> String.format("%." + col.precision + "f", ((Number)value).doubleValue());
            case 0 -> String.valueOf(value);
        };
    }

    @NonNull
    private static String padRight(@NonNull String s, int width) {
        return s.length() >= width ? s : s + " ".repeat(width - s.length());
    }

    @NonNull
    private static String padLeft(@NonNull String s, int width) {
        return s.length() >= width ? s : " ".repeat(width - s.length()) + s;
    }

    @NonNull
    public static Builder column(@NonNull String name) {
        Builder builder = new Builder();
        return builder.column(name);
    }

    private static class ColumnDef {
        String header;
        ColumnType type = ColumnType.STRING;
        int width;
        int precision;
        String fixedValue;

        private ColumnDef() {
        }
    }

    private static enum ColumnType {
        STRING,
        INT,
        FLOAT;

    }

    public static class Builder {
        private final List<ColumnDef> columns = new ArrayList<ColumnDef>();

        private Builder() {
        }

        @NonNull
        private ColumnDef lastColumn() {
            return this.columns.getLast();
        }

        @NonNull
        public Builder column(@NonNull String name) {
            ColumnDef col = new ColumnDef();
            col.header = name;
            this.columns.add(col);
            return this;
        }

        @NonNull
        public Builder column() {
            this.columns.add(new ColumnDef());
            return this;
        }

        @NonNull
        public Builder typeFloat(int width, int precision) {
            this.lastColumn().type = ColumnType.FLOAT;
            this.lastColumn().width = width;
            this.lastColumn().precision = precision;
            return this;
        }

        @NonNull
        public Builder typeInt(int width) {
            this.lastColumn().type = ColumnType.INT;
            this.lastColumn().width = width;
            return this;
        }

        @NonNull
        public Builder withFixedValue(@NonNull String value) {
            this.lastColumn().fixedValue = value;
            return this;
        }

        @NonNull
        public Builder fixedValue(@NonNull String value) {
            this.column();
            this.lastColumn().fixedValue = value;
            return this;
        }

        @NonNull
        public StringTable build() {
            return new StringTable(this.columns);
        }
    }
}

