/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.hapi.fees.FeeKeyUtils;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class ConsensusUpdateTopicFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @Nullable SimpleFeeContext feeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        ConsensusUpdateTopicTransactionBody op = txnBody.consensusUpdateTopicOrThrow();
        long keys = 0L;
        if (op.hasAdminKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.adminKeyOrThrow());
        }
        if (op.hasFeeScheduleKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.feeScheduleKeyOrThrow());
        }
        if (op.hasSubmitKey()) {
            keys += FeeKeyUtils.countKeys((Key)op.submitKeyOrThrow());
        }
        if (op.hasFeeExemptKeyList()) {
            for (Key key : op.feeExemptKeyList().keys()) {
                keys += FeeKeyUtils.countKeys((Key)key);
            }
        }
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CONSENSUS_UPDATE_TOPIC);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        this.addExtraFee(feeResult, serviceDef, Extra.KEYS, feeSchedule, keys);
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CONSENSUS_UPDATE_TOPIC;
    }
}

