/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.addressbook;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.addressbook.codec.NodeJsonCodec;
import com.hedera.hapi.node.state.addressbook.codec.NodeProtoCodec;
import com.hedera.hapi.node.state.addressbook.schema.NodeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class Node {
    public static final Codec<Node> PROTOBUF = new NodeProtoCodec();
    public static final JsonCodec<Node> JSON = new NodeJsonCodec();
    public static final Node DEFAULT = Node.newBuilder().build();
    private final long nodeId;
    @Nullable
    private final AccountID accountId;
    @NonNull
    private final String description;
    @NonNull
    private final List<ServiceEndpoint> gossipEndpoint;
    @NonNull
    private final List<ServiceEndpoint> serviceEndpoint;
    @NonNull
    private final Bytes gossipCaCertificate;
    @NonNull
    private final Bytes grpcCertificateHash;
    private final long weight;
    private final boolean deleted;
    @Nullable
    private final Key adminKey;
    private final boolean declineReward;
    @Nullable
    private final ServiceEndpoint grpcProxyEndpoint;
    @NonNull
    private final List<Long> associatedRegisteredNode;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public Node(long nodeId, AccountID accountId, String description, List<ServiceEndpoint> gossipEndpoint, List<ServiceEndpoint> serviceEndpoint, Bytes gossipCaCertificate, Bytes grpcCertificateHash, long weight, boolean deleted, Key adminKey, boolean declineReward, ServiceEndpoint grpcProxyEndpoint, List<Long> associatedRegisteredNode) {
        this.$unknownFields = null;
        this.nodeId = nodeId;
        this.accountId = accountId;
        this.description = description != null ? description : "";
        this.gossipEndpoint = gossipEndpoint == null ? Collections.emptyList() : gossipEndpoint;
        this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
        this.gossipCaCertificate = gossipCaCertificate != null ? gossipCaCertificate : Bytes.EMPTY;
        this.grpcCertificateHash = grpcCertificateHash != null ? grpcCertificateHash : Bytes.EMPTY;
        this.weight = weight;
        this.deleted = deleted;
        this.adminKey = adminKey;
        this.declineReward = declineReward;
        this.grpcProxyEndpoint = grpcProxyEndpoint;
        this.associatedRegisteredNode = associatedRegisteredNode == null ? Collections.emptyList() : associatedRegisteredNode;
    }

    public Node(long nodeId, AccountID accountId, String description, List<ServiceEndpoint> gossipEndpoint, List<ServiceEndpoint> serviceEndpoint, Bytes gossipCaCertificate, Bytes grpcCertificateHash, long weight, boolean deleted, Key adminKey, boolean declineReward, ServiceEndpoint grpcProxyEndpoint, List<Long> associatedRegisteredNode, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.nodeId = nodeId;
        this.accountId = accountId;
        this.description = description != null ? description : "";
        this.gossipEndpoint = gossipEndpoint == null ? Collections.emptyList() : gossipEndpoint;
        this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
        this.gossipCaCertificate = gossipCaCertificate != null ? gossipCaCertificate : Bytes.EMPTY;
        this.grpcCertificateHash = grpcCertificateHash != null ? grpcCertificateHash : Bytes.EMPTY;
        this.weight = weight;
        this.deleted = deleted;
        this.adminKey = adminKey;
        this.declineReward = declineReward;
        this.grpcProxyEndpoint = grpcProxyEndpoint;
        this.associatedRegisteredNode = associatedRegisteredNode == null ? Collections.emptyList() : associatedRegisteredNode;
    }

    public long nodeId() {
        return this.nodeId;
    }

    public AccountID accountId() {
        return this.accountId;
    }

    public String description() {
        return this.description;
    }

    public List<ServiceEndpoint> gossipEndpoint() {
        return this.gossipEndpoint;
    }

    public List<ServiceEndpoint> serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public Bytes gossipCaCertificate() {
        return this.gossipCaCertificate;
    }

    public Bytes grpcCertificateHash() {
        return this.grpcCertificateHash;
    }

    public long weight() {
        return this.weight;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public Key adminKey() {
        return this.adminKey;
    }

    public boolean declineReward() {
        return this.declineReward;
    }

    public ServiceEndpoint grpcProxyEndpoint() {
        return this.grpcProxyEndpoint;
    }

    public List<Long> associatedRegisteredNode() {
        return this.associatedRegisteredNode;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeSchema.NODE_ID, (long)this.nodeId, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeSchema.ACCOUNT_ID, (Object)this.accountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)NodeSchema.DESCRIPTION, (String)this.description, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)NodeSchema.GOSSIP_ENDPOINT, this.gossipEndpoint, ServiceEndpoint.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)NodeSchema.SERVICE_ENDPOINT, this.serviceEndpoint, ServiceEndpoint.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)NodeSchema.GOSSIP_CA_CERTIFICATE, (RandomAccessData)this.gossipCaCertificate, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)NodeSchema.GRPC_CERTIFICATE_HASH, (RandomAccessData)this.grpcCertificateHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeSchema.WEIGHT, (long)this.weight, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)NodeSchema.DELETED, (boolean)this.deleted, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeSchema.ADMIN_KEY, (Object)this.adminKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)NodeSchema.DECLINE_REWARD, (boolean)this.declineReward, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeSchema.GRPC_PROXY_ENDPOINT, (Object)this.grpcProxyEndpoint, ServiceEndpoint.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLongList((FieldDefinition)NodeSchema.ASSOCIATED_REGISTERED_NODE, this.associatedRegisteredNode);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.$hashCode == -1) {
            List<Long> list;
            List<ServiceEndpoint> list$serviceEndpoint;
            List<ServiceEndpoint> list$gossipEndpoint;
            int result = 1;
            if (this.nodeId != Node.DEFAULT.nodeId) {
                result = 31 * result + Long.hashCode(this.nodeId);
            }
            if (this.accountId != null && !this.accountId.equals(Node.DEFAULT.accountId)) {
                result = 31 * result + this.accountId.hashCode();
            }
            if (this.description != null && !this.description.equals(Node.DEFAULT.description)) {
                result = 31 * result + this.description.hashCode();
            }
            if ((list$gossipEndpoint = this.gossipEndpoint) != null) {
                for (ServiceEndpoint serviceEndpoint : list$gossipEndpoint) {
                    if (serviceEndpoint != null) {
                        result = 31 * result + ((Object)serviceEndpoint).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if ((list$serviceEndpoint = this.serviceEndpoint) != null) {
                for (ServiceEndpoint serviceEndpoint : list$serviceEndpoint) {
                    if (serviceEndpoint != null) {
                        result = 31 * result + ((Object)serviceEndpoint).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.gossipCaCertificate != null && !this.gossipCaCertificate.equals((Object)Node.DEFAULT.gossipCaCertificate)) {
                result = 31 * result + this.gossipCaCertificate.hashCode();
            }
            if (this.grpcCertificateHash != null && !this.grpcCertificateHash.equals((Object)Node.DEFAULT.grpcCertificateHash)) {
                result = 31 * result + this.grpcCertificateHash.hashCode();
            }
            if (this.weight != Node.DEFAULT.weight) {
                result = 31 * result + Long.hashCode(this.weight);
            }
            if (this.deleted != Node.DEFAULT.deleted) {
                result = 31 * result + Boolean.hashCode(this.deleted);
            }
            if (this.adminKey != null && !this.adminKey.equals(Node.DEFAULT.adminKey)) {
                result = 31 * result + this.adminKey.hashCode();
            }
            if (this.declineReward != Node.DEFAULT.declineReward) {
                result = 31 * result + Boolean.hashCode(this.declineReward);
            }
            if (this.grpcProxyEndpoint != null && !this.grpcProxyEndpoint.equals(Node.DEFAULT.grpcProxyEndpoint)) {
                result = 31 * result + this.grpcProxyEndpoint.hashCode();
            }
            if ((list = this.associatedRegisteredNode) != null) {
                for (Long l : list) {
                    if (l != null) {
                        result = 31 * result + ((Object)l).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.$unknownFields != null) {
                void var5_12;
                boolean bl = false;
                while (var5_12 < this.$unknownFields.size()) {
                    result = 31 * result + this.$unknownFields.get((int)var5_12).hashCode();
                    ++var5_12;
                }
            }
            long l = result;
            l += l << 30;
            l ^= l >>> 27;
            l += l << 16;
            l ^= l >>> 20;
            l += l << 5;
            l ^= l >>> 18;
            l += l << 10;
            l ^= l >>> 24;
            l += l << 30;
            this.$hashCode = (int)l;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Node thatObj = (Node)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.nodeId != thatObj.nodeId) {
            return false;
        }
        if (this.accountId == null && thatObj.accountId != null) {
            return false;
        }
        if (this.accountId != null && !this.accountId.equals(thatObj.accountId)) {
            return false;
        }
        if (this.description == null && thatObj.description != null) {
            return false;
        }
        if (this.description != null && !this.description.equals(thatObj.description)) {
            return false;
        }
        if (this.gossipEndpoint == null && thatObj.gossipEndpoint != null) {
            return false;
        }
        if (this.gossipEndpoint != null && !this.gossipEndpoint.equals(thatObj.gossipEndpoint)) {
            return false;
        }
        if (this.serviceEndpoint == null && thatObj.serviceEndpoint != null) {
            return false;
        }
        if (this.serviceEndpoint != null && !this.serviceEndpoint.equals(thatObj.serviceEndpoint)) {
            return false;
        }
        if (this.gossipCaCertificate == null && thatObj.gossipCaCertificate != null) {
            return false;
        }
        if (this.gossipCaCertificate != null && !this.gossipCaCertificate.equals((Object)thatObj.gossipCaCertificate)) {
            return false;
        }
        if (this.grpcCertificateHash == null && thatObj.grpcCertificateHash != null) {
            return false;
        }
        if (this.grpcCertificateHash != null && !this.grpcCertificateHash.equals((Object)thatObj.grpcCertificateHash)) {
            return false;
        }
        if (this.weight != thatObj.weight) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.declineReward != thatObj.declineReward) {
            return false;
        }
        if (this.grpcProxyEndpoint == null && thatObj.grpcProxyEndpoint != null) {
            return false;
        }
        if (this.grpcProxyEndpoint != null && !this.grpcProxyEndpoint.equals(thatObj.grpcProxyEndpoint)) {
            return false;
        }
        if (this.associatedRegisteredNode == null && thatObj.associatedRegisteredNode != null) {
            return false;
        }
        if (this.associatedRegisteredNode != null && !this.associatedRegisteredNode.equals(thatObj.associatedRegisteredNode)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "Node[nodeId=" + this.nodeId + ", accountId=" + String.valueOf(this.accountId) + ", description=" + this.description + ", gossipEndpoint=" + String.valueOf(this.gossipEndpoint) + ", serviceEndpoint=" + String.valueOf(this.serviceEndpoint) + ", gossipCaCertificate=" + String.valueOf(this.gossipCaCertificate) + ", grpcCertificateHash=" + String.valueOf(this.grpcCertificateHash) + ", weight=" + this.weight + ", deleted=" + this.deleted + ", adminKey=" + String.valueOf(this.adminKey) + ", declineReward=" + this.declineReward + ", grpcProxyEndpoint=" + String.valueOf(this.grpcProxyEndpoint) + ", associatedRegisteredNode=" + String.valueOf(this.associatedRegisteredNode) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasAccountId() {
        return this.accountId != null;
    }

    public AccountID accountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountId() ? this.accountId : defaultValue;
    }

    @NonNull
    public AccountID accountIdOrThrow() {
        return Objects.requireNonNull(this.accountId, "Field accountId is null");
    }

    public void ifAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountId()) {
            ifPresent.accept(this.accountId);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasGrpcProxyEndpoint() {
        return this.grpcProxyEndpoint != null;
    }

    public ServiceEndpoint grpcProxyEndpointOrElse(@NonNull ServiceEndpoint defaultValue) {
        return this.hasGrpcProxyEndpoint() ? this.grpcProxyEndpoint : defaultValue;
    }

    @NonNull
    public ServiceEndpoint grpcProxyEndpointOrThrow() {
        return Objects.requireNonNull(this.grpcProxyEndpoint, "Field grpcProxyEndpoint is null");
    }

    public void ifGrpcProxyEndpoint(@NonNull Consumer<ServiceEndpoint> ifPresent) {
        if (this.hasGrpcProxyEndpoint()) {
            ifPresent.accept(this.grpcProxyEndpoint);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.nodeId, this.accountId, this.description, this.gossipEndpoint, this.serviceEndpoint, this.gossipCaCertificate, this.grpcCertificateHash, this.weight, this.deleted, this.adminKey, this.declineReward, this.grpcProxyEndpoint, this.associatedRegisteredNode, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long nodeId = 0L;
        @Nullable
        private AccountID accountId = null;
        @NonNull
        private String description = "";
        @NonNull
        private List<ServiceEndpoint> gossipEndpoint = Collections.emptyList();
        @NonNull
        private List<ServiceEndpoint> serviceEndpoint = Collections.emptyList();
        @NonNull
        private Bytes gossipCaCertificate = Bytes.EMPTY;
        @NonNull
        private Bytes grpcCertificateHash = Bytes.EMPTY;
        private long weight = 0L;
        private boolean deleted = false;
        @Nullable
        private Key adminKey = null;
        private boolean declineReward = false;
        @Nullable
        private ServiceEndpoint grpcProxyEndpoint = null;
        @NonNull
        private List<Long> associatedRegisteredNode = Collections.emptyList();
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long nodeId, AccountID accountId, String description, List<ServiceEndpoint> gossipEndpoint, List<ServiceEndpoint> serviceEndpoint, Bytes gossipCaCertificate, Bytes grpcCertificateHash, long weight, boolean deleted, Key adminKey, boolean declineReward, ServiceEndpoint grpcProxyEndpoint, List<Long> associatedRegisteredNode) {
            this.$unknownFields = null;
            this.nodeId = nodeId;
            this.accountId = accountId;
            this.description = description != null ? description : "";
            this.gossipEndpoint = gossipEndpoint == null ? Collections.emptyList() : gossipEndpoint;
            this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
            this.gossipCaCertificate = gossipCaCertificate != null ? gossipCaCertificate : Bytes.EMPTY;
            this.grpcCertificateHash = grpcCertificateHash != null ? grpcCertificateHash : Bytes.EMPTY;
            this.weight = weight;
            this.deleted = deleted;
            this.adminKey = adminKey;
            this.declineReward = declineReward;
            this.grpcProxyEndpoint = grpcProxyEndpoint;
            this.associatedRegisteredNode = associatedRegisteredNode == null ? Collections.emptyList() : associatedRegisteredNode;
        }

        public Builder(long nodeId, AccountID accountId, String description, List<ServiceEndpoint> gossipEndpoint, List<ServiceEndpoint> serviceEndpoint, Bytes gossipCaCertificate, Bytes grpcCertificateHash, long weight, boolean deleted, Key adminKey, boolean declineReward, ServiceEndpoint grpcProxyEndpoint, List<Long> associatedRegisteredNode, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.nodeId = nodeId;
            this.accountId = accountId;
            this.description = description != null ? description : "";
            this.gossipEndpoint = gossipEndpoint == null ? Collections.emptyList() : gossipEndpoint;
            this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
            this.gossipCaCertificate = gossipCaCertificate != null ? gossipCaCertificate : Bytes.EMPTY;
            this.grpcCertificateHash = grpcCertificateHash != null ? grpcCertificateHash : Bytes.EMPTY;
            this.weight = weight;
            this.deleted = deleted;
            this.adminKey = adminKey;
            this.declineReward = declineReward;
            this.grpcProxyEndpoint = grpcProxyEndpoint;
            this.associatedRegisteredNode = associatedRegisteredNode == null ? Collections.emptyList() : associatedRegisteredNode;
        }

        public Node build() {
            return new Node(this.nodeId, this.accountId, this.description, this.gossipEndpoint, this.serviceEndpoint, this.gossipCaCertificate, this.grpcCertificateHash, this.weight, this.deleted, this.adminKey, this.declineReward, this.grpcProxyEndpoint, this.associatedRegisteredNode);
        }

        public Builder nodeId(long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder accountId(@Nullable AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountId(AccountID.Builder builder) {
            this.accountId = builder.build();
            return this;
        }

        public Builder description(@NonNull String description) {
            this.description = description != null ? description : "";
            return this;
        }

        public Builder gossipEndpoint(@NonNull List<ServiceEndpoint> gossipEndpoint) {
            this.gossipEndpoint = gossipEndpoint != null ? gossipEndpoint : Collections.emptyList();
            return this;
        }

        public Builder gossipEndpoint(ServiceEndpoint ... values) {
            this.gossipEndpoint = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder serviceEndpoint(@NonNull List<ServiceEndpoint> serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint != null ? serviceEndpoint : Collections.emptyList();
            return this;
        }

        public Builder serviceEndpoint(ServiceEndpoint ... values) {
            this.serviceEndpoint = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder gossipCaCertificate(@NonNull Bytes gossipCaCertificate) {
            this.gossipCaCertificate = gossipCaCertificate != null ? gossipCaCertificate : Bytes.EMPTY;
            return this;
        }

        public Builder grpcCertificateHash(@NonNull Bytes grpcCertificateHash) {
            this.grpcCertificateHash = grpcCertificateHash != null ? grpcCertificateHash : Bytes.EMPTY;
            return this;
        }

        public Builder weight(long weight) {
            this.weight = weight;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder declineReward(boolean declineReward) {
            this.declineReward = declineReward;
            return this;
        }

        public Builder grpcProxyEndpoint(@Nullable ServiceEndpoint grpcProxyEndpoint) {
            this.grpcProxyEndpoint = grpcProxyEndpoint;
            return this;
        }

        public Builder grpcProxyEndpoint(ServiceEndpoint.Builder builder) {
            this.grpcProxyEndpoint = builder.build();
            return this;
        }

        public Builder associatedRegisteredNode(@NonNull List<Long> associatedRegisteredNode) {
            this.associatedRegisteredNode = associatedRegisteredNode != null ? associatedRegisteredNode : Collections.emptyList();
            return this;
        }

        public Builder associatedRegisteredNode(Long ... values) {
            this.associatedRegisteredNode = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public long nodeId() {
            return this.nodeId;
        }

        public AccountID accountId() {
            return this.accountId;
        }

        public String description() {
            return this.description;
        }

        public List<ServiceEndpoint> gossipEndpoint() {
            return this.gossipEndpoint;
        }

        public List<ServiceEndpoint> serviceEndpoint() {
            return this.serviceEndpoint;
        }

        public Bytes gossipCaCertificate() {
            return this.gossipCaCertificate;
        }

        public Bytes grpcCertificateHash() {
            return this.grpcCertificateHash;
        }

        public long weight() {
            return this.weight;
        }

        public boolean deleted() {
            return this.deleted;
        }

        public Key adminKey() {
            return this.adminKey;
        }

        public boolean declineReward() {
            return this.declineReward;
        }

        public ServiceEndpoint grpcProxyEndpoint() {
            return this.grpcProxyEndpoint;
        }

        public List<Long> associatedRegisteredNode() {
            return this.associatedRegisteredNode;
        }
    }
}

