/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.history.codec;

import com.hedera.hapi.node.state.history.AggregatedNodeSignatures;
import com.hedera.hapi.node.state.history.schema.AggregatedNodeSignaturesSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AggregatedNodeSignaturesJsonCodec
implements JsonCodec<AggregatedNodeSignatures> {
    @NonNull
    public AggregatedNodeSignatures parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_aggregated_signature = Bytes.EMPTY;
            List<Long> temp_signing_node_ids = Collections.emptyList();
            Bytes temp_verification_key = Bytes.EMPTY;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "aggregatedSignature": {
                        temp_aggregated_signature = Bytes.fromBase64((String)JsonTools.checkSize((String)"aggregated_signature", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                    case "signingNodeIds": {
                        temp_signing_node_ids = JsonTools.checkSize((String)"signing_node_ids", (List)kvPair.value().arr().value(), (int)maxSize).stream().map(v -> JsonTools.parseLong((JSONParser.ValueContext)v)).toList();
                        continue block12;
                    }
                    case "verificationKey": {
                        temp_verification_key = Bytes.fromBase64((String)JsonTools.checkSize((String)"verification_key", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new AggregatedNodeSignatures(temp_aggregated_signature, temp_signing_node_ids, temp_verification_key);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull AggregatedNodeSignatures data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.aggregatedSignature() != Bytes.EMPTY && data.aggregatedSignature() != null && data.aggregatedSignature().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"aggregatedSignature", (Bytes)data.aggregatedSignature()));
        }
        if (!data.signingNodeIds().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"signingNodeIds", (FieldDefinition)AggregatedNodeSignaturesSchema.SIGNING_NODE_IDS, data.signingNodeIds()));
        }
        if (data.verificationKey() != Bytes.EMPTY && data.verificationKey() != null && data.verificationKey().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"verificationKey", (Bytes)data.verificationKey()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

